package ru.yandex.autotests.direct.intapi.codegen;

import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.properties.Property;
import org.apache.commons.lang3.StringEscapeUtils;

/*
* todo javadoc
*/
public class DirectIntapiJavaClientCodegen extends JavaClientCodegen {
    public DirectIntapiJavaClientCodegen() {
        //in some resson it is false in parent class, looks like a bug
        this.supportsInheritance = true;
    }

    //standard uses StringEscapeUtils.escapeJava escapes all cyrillic symbols too
    @Override
    public String escapeText(String input) {
        return input == null ? null : StringEscapeUtils.escapeHtml4(input).replace("\\/", "/");
    }

    @Override
    public CodegenProperty fromProperty(String name, Property p) {
        CodegenProperty property = super.fromProperty(name, p);
        property.vendorExtensions.put("capitalizedName", camelize(property.name));
        return property;
    }
}
