package ru.yandex.autotests.direct.intapi;

import ru.yandex.autotests.direct.intapi.client.CollectionFormats.*;


import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;

import ru.yandex.autotests.direct.intapi.models.Privileges;
import ru.yandex.autotests.direct.intapi.models.ErrorResponse;
import ru.yandex.autotests.direct.intapi.models.CreativeCampaignRequest;
import ru.yandex.autotests.direct.intapi.models.GetUsedCreativesResponse;
import ru.yandex.autotests.direct.intapi.models.CreativeUploadData;
import ru.yandex.autotests.direct.intapi.models.CreativeUploadResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DisplaycanvascontrollerApi {
  
  /**
   * получение прав пользователя
   * 
   * @param userId текущий паспортный uid пользователя из конструктора креативов (optional)
   * @param clientId id клиента из баланса, на него хранятся креативы в конструкторе (передается как одноименный get параметр при открыти iframe c конструктором) (optional)
   * @return Call<Privileges>
   */
  
  @GET("DisplayCanvas/authenticate")
  Call<Privileges> authenticate(
    @Query("user_id") Long userId, @Query("client_id") Long clientId
  );

  
  /**
   * получение кампаний по заданным креативам
   * 
   * @param operatorUid текущий паспортный uid пользователя из конструктора креативов (required)
   * @param clientId id клиента из баланса, на него хранятся креативы в конструкторе (передается как одноименный get параметр при открыти iframe c конструктором) (required)
   * @param request Список id креативов, по которым хотим найти кампании (required)
   * @return Call<Object>
   */
  
  @POST("DisplayCanvas/get_creatives_campaigns")
  Call<Object> getCreativesCampaigns(
    @Query("operator_uid") Long operatorUid, @Query("client_id") Long clientId, @Body CreativeCampaignRequest request
  );

  
  /**
   * получение используемых клиентом креативов
   * 
   * @param clientId id клиента из баланса, на него хранятся креативы в конструкторе (required)
   * @param creativeType тип креатива (required)
   * @param nextPageToken токен, позволяющий получить следующий блок данных (optional)
   * @param limit лимит (optional)
   * @param sort сортировка asc/desc по ид креатива (optional)
   * @return Call<GetUsedCreativesResponse>
   */
  
  @GET("DisplayCanvas/get_used_creatives")
  Call<GetUsedCreativesResponse> getUsedCreatives(
    @Query("client_id") Long clientId, @Query("creative_type") String creativeType, @Query("next_page_token") String nextPageToken, @Query("limit") Integer limit, @Query("sort") String sort
  );

  
  /**
   * проверка  работоспособности ручки authenticate
   * 
   * @return Call<String>
   */
  
  @GET("DisplayCanvas/ping")
  Call<String> ping();
    

  
  /**
   * создание креативов
   * 
   * @param operatorUid текущий паспортный uid пользователя из конструктора креативов (required)
   * @param clientId id клиента из баланса, на него хранятся креативы в конструкторе (передается как одноименный get параметр при открыти iframe c конструктором) (required)
   * @param creatives Список креативов (required)
   * @return Call<CreativeUploadResponse>
   */
  
  @POST("DisplayCanvas/upload_creatives")
  Call<CreativeUploadResponse> uploadCreatives(
    @Query("operator_uid") Long operatorUid, @Query("client_id") Long clientId, @Body List<CreativeUploadData> creatives
  );

  
}
