package ru.yandex.autotests.direct.intapi.models;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import ru.yandex.autotests.direct.intapi.models.AdditionalData;
import ru.yandex.autotests.direct.intapi.models.ModerationInfo;
import ru.yandex.autotests.direct.intapi.models.YabsData;

import com.google.gson.annotations.SerializedName;





public class CreativeUploadData   {
  
  @SerializedName("additional_data")
  protected AdditionalData additionalData = null;
  
  @SerializedName("archive_url")
  protected String archiveUrl = null;
  

public enum ComposedFromEnum {
  @SerializedName("gif")
  GIF("gif"),

  @SerializedName("jpg")
  JPG("jpg"),

  @SerializedName("png")
  PNG("png");

  private String value;

  ComposedFromEnum(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}

  @SerializedName("composed_from")
  protected ComposedFromEnum composedFrom = null;
  
  @SerializedName("creative_id")
  protected Long creativeId = null;
  
  @SerializedName("creative_name")
  protected String creativeName = null;
  

public enum CreativeTypeEnum {
  @SerializedName("image")
  IMAGE("image"),

  @SerializedName("videoAddition")
  VIDEOADDITION("videoAddition"),

  @SerializedName("html5")
  HTML5("html5");

  private String value;

  CreativeTypeEnum(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}

  @SerializedName("creative_type")
  protected CreativeTypeEnum creativeType = null;
  
  @SerializedName("duration")
  protected Long duration = null;
  
  @SerializedName("has_packshot")
  protected Boolean hasPackshot = null;
  
  @SerializedName("height")
  protected Integer height = null;
  
  @SerializedName("is_adaptive")
  protected Boolean isAdaptive = null;
  
  @SerializedName("live_preview_url")
  protected String livePreviewUrl = null;
  
  @SerializedName("moderation_info")
  protected ModerationInfo moderationInfo = null;
  
  @SerializedName("preset_id")
  protected Integer presetId = null;
  
  @SerializedName("preview_url")
  protected String previewUrl = null;
  
  @SerializedName("stock_creative_id")
  protected Long stockCreativeId = null;
  
  @SerializedName("width")
  protected Integer width = null;
  
  @SerializedName("yabs_data")
  protected YabsData yabsData = null;
  

  
  /**
   * дополнительные типоспецифичные данные
   **/
  @ApiModelProperty(value = "дополнительные типоспецифичные данные")
  public AdditionalData getAdditionalData() {
    return additionalData;
  }
  public void setAdditionalData(AdditionalData additionalData) {
    this.additionalData = additionalData;
  }
  public CreativeUploadData withAdditionalData(AdditionalData additionalData) {
    this.additionalData = additionalData;
    return this;
  }

  


  
  /**
   * ссылка на архив с креативом, для модерации чтобы его скачать и проверить
   **/
  @ApiModelProperty(value = "ссылка на архив с креативом, для модерации чтобы его скачать и проверить")
  public String getArchiveUrl() {
    return archiveUrl;
  }
  public void setArchiveUrl(String archiveUrl) {
    this.archiveUrl = archiveUrl;
  }
  public CreativeUploadData withArchiveUrl(String archiveUrl) {
    this.archiveUrl = archiveUrl;
    return this;
  }

  


  
  /**
   * Тип медиа из которого сформировали креатив (если применимо) - gif, jpg, png
   **/
  @ApiModelProperty(value = "Тип медиа из которого сформировали креатив (если применимо) - gif, jpg, png")
  public ComposedFromEnum getComposedFrom() {
    return composedFrom;
  }
  public void setComposedFrom(ComposedFromEnum composedFrom) {
    this.composedFrom = composedFrom;
  }
  public CreativeUploadData withComposedFrom(ComposedFromEnum composedFrom) {
    this.composedFrom = composedFrom;
    return this;
  }

  


  
  /**
   * id креатива
   **/
  @ApiModelProperty(required = true, value = "id креатива")
  public Long getCreativeId() {
    return creativeId;
  }
  public void setCreativeId(Long creativeId) {
    this.creativeId = creativeId;
  }
  public CreativeUploadData withCreativeId(Long creativeId) {
    this.creativeId = creativeId;
    return this;
  }

  


  
  /**
   * название креатива в BS
   **/
  @ApiModelProperty(required = true, value = "название креатива в BS")
  public String getCreativeName() {
    return creativeName;
  }
  public void setCreativeName(String creativeName) {
    this.creativeName = creativeName;
  }
  public CreativeUploadData withCreativeName(String creativeName) {
    this.creativeName = creativeName;
    return this;
  }

  


  
  /**
   * тип креатива
   **/
  @ApiModelProperty(required = true, value = "тип креатива")
  public CreativeTypeEnum getCreativeType() {
    return creativeType;
  }
  public void setCreativeType(CreativeTypeEnum creativeType) {
    this.creativeType = creativeType;
  }
  public CreativeUploadData withCreativeType(CreativeTypeEnum creativeType) {
    this.creativeType = creativeType;
    return this;
  }

  


  
  /**
   * длительность видео
   **/
  @ApiModelProperty(value = "длительность видео")
  public Long getDuration() {
    return duration;
  }
  public void setDuration(Long duration) {
    this.duration = duration;
  }
  public CreativeUploadData withDuration(Long duration) {
    this.duration = duration;
    return this;
  }

  


  
  /**
   * содержит ли packshot
   **/
  @ApiModelProperty(value = "содержит ли packshot")
  public Boolean getHasPackshot() {
    return hasPackshot;
  }
  public void setHasPackshot(Boolean hasPackshot) {
    this.hasPackshot = hasPackshot;
  }
  public CreativeUploadData withHasPackshot(Boolean hasPackshot) {
    this.hasPackshot = hasPackshot;
    return this;
  }

  


  
  /**
   * высота креатива в px
   **/
  @ApiModelProperty(value = "высота креатива в px")
  public Integer getHeight() {
    return height;
  }
  public void setHeight(Integer height) {
    this.height = height;
  }
  public CreativeUploadData withHeight(Integer height) {
    this.height = height;
    return this;
  }

  


  
  /**
   * является ли адаптивным
   **/
  @ApiModelProperty(value = "является ли адаптивным")
  public Boolean getIsAdaptive() {
    return isAdaptive;
  }
  public void setIsAdaptive(Boolean isAdaptive) {
    this.isAdaptive = isAdaptive;
  }
  public CreativeUploadData withIsAdaptive(Boolean isAdaptive) {
    this.isAdaptive = isAdaptive;
    return this;
  }

  


  
  /**
   * ссылка на видео превью креатива
   **/
  @ApiModelProperty(required = true, value = "ссылка на видео превью креатива")
  public String getLivePreviewUrl() {
    return livePreviewUrl;
  }
  public void setLivePreviewUrl(String livePreviewUrl) {
    this.livePreviewUrl = livePreviewUrl;
  }
  public CreativeUploadData withLivePreviewUrl(String livePreviewUrl) {
    this.livePreviewUrl = livePreviewUrl;
    return this;
  }

  


  
  /**
   * данные для передачи в модерацию
   **/
  @ApiModelProperty(value = "данные для передачи в модерацию")
  public ModerationInfo getModerationInfo() {
    return moderationInfo;
  }
  public void setModerationInfo(ModerationInfo moderationInfo) {
    this.moderationInfo = moderationInfo;
  }
  public CreativeUploadData withModerationInfo(ModerationInfo moderationInfo) {
    this.moderationInfo = moderationInfo;
    return this;
  }

  


  
  /**
   * пресет креатива
   **/
  @ApiModelProperty(value = "пресет креатива")
  public Integer getPresetId() {
    return presetId;
  }
  public void setPresetId(Integer presetId) {
    this.presetId = presetId;
  }
  public CreativeUploadData withPresetId(Integer presetId) {
    this.presetId = presetId;
    return this;
  }

  


  
  /**
   * ссылка на превью креатива
   **/
  @ApiModelProperty(required = true, value = "ссылка на превью креатива")
  public String getPreviewUrl() {
    return previewUrl;
  }
  public void setPreviewUrl(String previewUrl) {
    this.previewUrl = previewUrl;
  }
  public CreativeUploadData withPreviewUrl(String previewUrl) {
    this.previewUrl = previewUrl;
    return this;
  }

  


  
  /**
   * Ид креатива где хранятся на него ресурсы
   **/
  @ApiModelProperty(value = "Ид креатива где хранятся на него ресурсы")
  public Long getStockCreativeId() {
    return stockCreativeId;
  }
  public void setStockCreativeId(Long stockCreativeId) {
    this.stockCreativeId = stockCreativeId;
  }
  public CreativeUploadData withStockCreativeId(Long stockCreativeId) {
    this.stockCreativeId = stockCreativeId;
    return this;
  }

  


  
  /**
   * ширина креатива в px
   **/
  @ApiModelProperty(value = "ширина креатива в px")
  public Integer getWidth() {
    return width;
  }
  public void setWidth(Integer width) {
    this.width = width;
  }
  public CreativeUploadData withWidth(Integer width) {
    this.width = width;
    return this;
  }

  


  
  /**
   * данные для передачи в БК
   **/
  @ApiModelProperty(value = "данные для передачи в БК")
  public YabsData getYabsData() {
    return yabsData;
  }
  public void setYabsData(YabsData yabsData) {
    this.yabsData = yabsData;
  }
  public CreativeUploadData withYabsData(YabsData yabsData) {
    this.yabsData = yabsData;
    return this;
  }

  


  

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreativeUploadData creativeUploadData = (CreativeUploadData) o;
    return Objects.equals(this.additionalData, creativeUploadData.additionalData) &&
        Objects.equals(this.archiveUrl, creativeUploadData.archiveUrl) &&
        Objects.equals(this.composedFrom, creativeUploadData.composedFrom) &&
        Objects.equals(this.creativeId, creativeUploadData.creativeId) &&
        Objects.equals(this.creativeName, creativeUploadData.creativeName) &&
        Objects.equals(this.creativeType, creativeUploadData.creativeType) &&
        Objects.equals(this.duration, creativeUploadData.duration) &&
        Objects.equals(this.hasPackshot, creativeUploadData.hasPackshot) &&
        Objects.equals(this.height, creativeUploadData.height) &&
        Objects.equals(this.isAdaptive, creativeUploadData.isAdaptive) &&
        Objects.equals(this.livePreviewUrl, creativeUploadData.livePreviewUrl) &&
        Objects.equals(this.moderationInfo, creativeUploadData.moderationInfo) &&
        Objects.equals(this.presetId, creativeUploadData.presetId) &&
        Objects.equals(this.previewUrl, creativeUploadData.previewUrl) &&
        Objects.equals(this.stockCreativeId, creativeUploadData.stockCreativeId) &&
        Objects.equals(this.width, creativeUploadData.width) &&
        Objects.equals(this.yabsData, creativeUploadData.yabsData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(additionalData, archiveUrl, composedFrom, creativeId, creativeName, creativeType, duration, hasPackshot, height, isAdaptive, livePreviewUrl, moderationInfo, presetId, previewUrl, stockCreativeId, width, yabsData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreativeUploadData {\n");
    
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    archiveUrl: ").append(toIndentedString(archiveUrl)).append("\n");
    sb.append("    composedFrom: ").append(toIndentedString(composedFrom)).append("\n");
    sb.append("    creativeId: ").append(toIndentedString(creativeId)).append("\n");
    sb.append("    creativeName: ").append(toIndentedString(creativeName)).append("\n");
    sb.append("    creativeType: ").append(toIndentedString(creativeType)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    hasPackshot: ").append(toIndentedString(hasPackshot)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    isAdaptive: ").append(toIndentedString(isAdaptive)).append("\n");
    sb.append("    livePreviewUrl: ").append(toIndentedString(livePreviewUrl)).append("\n");
    sb.append("    moderationInfo: ").append(toIndentedString(moderationInfo)).append("\n");
    sb.append("    presetId: ").append(toIndentedString(presetId)).append("\n");
    sb.append("    previewUrl: ").append(toIndentedString(previewUrl)).append("\n");
    sb.append("    stockCreativeId: ").append(toIndentedString(stockCreativeId)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    yabsData: ").append(toIndentedString(yabsData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
