package ru.yandex.autotests.direct.intapi.models;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import ru.yandex.autotests.direct.intapi.models.CreativeUploadResult;

import com.google.gson.annotations.SerializedName;





public class CreativeUploadResponse   {
  
  @SerializedName("success")
  protected Boolean success = null;
  
  @SerializedName("uploadResults")
  protected List<CreativeUploadResult> uploadResults = new ArrayList<CreativeUploadResult>();
  

  
  /**
   **/
  @ApiModelProperty(value = "")
  public Boolean getSuccess() {
    return success;
  }
  public void setSuccess(Boolean success) {
    this.success = success;
  }
  public CreativeUploadResponse withSuccess(Boolean success) {
    this.success = success;
    return this;
  }

  


  
  /**
   * результат обработки креативов
   **/
  @ApiModelProperty(required = true, value = "результат обработки креативов")
  public List<CreativeUploadResult> getUploadResults() {
    return uploadResults;
  }
  public void setUploadResults(List<CreativeUploadResult> uploadResults) {
    this.uploadResults = uploadResults;
  }
  public CreativeUploadResponse withUploadResults(List<CreativeUploadResult> uploadResults) {
    this.uploadResults = uploadResults;
    return this;
  }

  


  

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreativeUploadResponse creativeUploadResponse = (CreativeUploadResponse) o;
    return Objects.equals(this.success, creativeUploadResponse.success) &&
        Objects.equals(this.uploadResults, creativeUploadResponse.uploadResults);
  }

  @Override
  public int hashCode() {
    return Objects.hash(success, uploadResults);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreativeUploadResponse {\n");
    
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    uploadResults: ").append(toIndentedString(uploadResults)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
