package ru.yandex.autotests.direct.intapi.models;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;





public class CreativeUploadResult   {
  
  @SerializedName("creative_id")
  protected Long creativeId = null;
  
  @SerializedName("message")
  protected String message = null;
  

public enum StatusEnum {
  @SerializedName("OK")
  OK("OK"),

  @SerializedName("WARNING")
  WARNING("WARNING"),

  @SerializedName("ERROR")
  ERROR("ERROR");

  private String value;

  StatusEnum(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}

  @SerializedName("status")
  protected StatusEnum status = null;
  

  
  /**
   * id креатива
   **/
  @ApiModelProperty(required = true, value = "id креатива")
  public Long getCreativeId() {
    return creativeId;
  }
  public void setCreativeId(Long creativeId) {
    this.creativeId = creativeId;
  }
  public CreativeUploadResult withCreativeId(Long creativeId) {
    this.creativeId = creativeId;
    return this;
  }

  


  
  /**
   * статус обработки креатива: поясняющее сообщение
   **/
  @ApiModelProperty(required = true, value = "статус обработки креатива: поясняющее сообщение")
  public String getMessage() {
    return message;
  }
  public void setMessage(String message) {
    this.message = message;
  }
  public CreativeUploadResult withMessage(String message) {
    this.message = message;
    return this;
  }

  


  
  /**
   * статус обработки креатива
   **/
  @ApiModelProperty(required = true, value = "статус обработки креатива")
  public StatusEnum getStatus() {
    return status;
  }
  public void setStatus(StatusEnum status) {
    this.status = status;
  }
  public CreativeUploadResult withStatus(StatusEnum status) {
    this.status = status;
    return this;
  }

  


  

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreativeUploadResult creativeUploadResult = (CreativeUploadResult) o;
    return Objects.equals(this.creativeId, creativeUploadResult.creativeId) &&
        Objects.equals(this.message, creativeUploadResult.message) &&
        Objects.equals(this.status, creativeUploadResult.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(creativeId, message, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreativeUploadResult {\n");
    
    sb.append("    creativeId: ").append(toIndentedString(creativeId)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
