package ru.yandex.autotests.direct.intapi.models;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.google.gson.annotations.SerializedName;





public class ErrorResponse   {
  

public enum CodeEnum {
  @SerializedName("PERMISSION_DENIED")
  PERMISSION_DENIED("PERMISSION_DENIED"),

  @SerializedName("BAD_PARAM")
  BAD_PARAM("BAD_PARAM"),

  @SerializedName("INTERNAL_ERROR")
  INTERNAL_ERROR("INTERNAL_ERROR"),

  @SerializedName("NOT_FOUND")
  NOT_FOUND("NOT_FOUND"),

  @SerializedName("TOO_MANY_REQUESTS")
  TOO_MANY_REQUESTS("TOO_MANY_REQUESTS");

  private String value;

  CodeEnum(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}

  @SerializedName("code")
  protected CodeEnum code = null;
  
  @SerializedName("message")
  protected String message = null;
  

  
  /**
   * код ошибки
   **/
  @ApiModelProperty(required = true, value = "код ошибки")
  public CodeEnum getCode() {
    return code;
  }
  public void setCode(CodeEnum code) {
    this.code = code;
  }
  public ErrorResponse withCode(CodeEnum code) {
    this.code = code;
    return this;
  }

  


  
  /**
   * причина ошибки
   **/
  @ApiModelProperty(required = true, value = "причина ошибки")
  public String getMessage() {
    return message;
  }
  public void setMessage(String message) {
    this.message = message;
  }
  public ErrorResponse withMessage(String message) {
    this.message = message;
    return this;
  }

  


  

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ErrorResponse errorResponse = (ErrorResponse) o;
    return Objects.equals(this.code, errorResponse.code) &&
        Objects.equals(this.message, errorResponse.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ErrorResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
