package ru.yandex.autotests.directintapi.utils;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.directapi.steps.clients.ClientSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.Matchers.hasItemInArray;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author xy6er
 * Date 30.09.14
 */
public class ClientStepsHelper {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private ClientSteps clientSteps;
    private int attempts;
    private Integer[] ignoreErrorCodes; //Коды ошибок при получении которых перезапускаем создание клиента

    public ClientStepsHelper(ClientSteps clientSteps) {
        this(clientSteps, DirectTestRunProperties.getInstance().getDirectIntapiAttemptsToCreateNewClient());
    }

    public ClientStepsHelper(ClientSteps clientSteps, int attempts) {
        this.clientSteps = clientSteps;
        this.attempts = attempts;
        this.ignoreErrorCodes = new Integer[]{252, 253, 254, 255, 258}; //https://tech.yandex.ru/direct/doc/dg-v4/reference/ErrorCodes-docpage/#ErrorCode252
    }

    public <T> T createServicedClient(String base, String mngrLogin) {
        return createNewServicedSubClient(base, mngrLogin, null);
    }

    @Step("INTAPI СlientStepsHelper: {method}")
    public <T> T createNewServicedSubClient(String base, String mngrLogin, Currency currency) {
        for (int i = 1; i <= attempts; i++) {
            try {
                log.info("Попытка создания клиента номер " + i);
                return clientSteps.createNewServicedSubClient(base, mngrLogin, currency);
            } catch (AxisError error) {
                assertThat("Не совпал код ошибки", ignoreErrorCodes, hasItemInArray(error.getErrorCode()));
            }
        }
        throw new DarkSideException("Не удалось создать клиента. Кол-во попыток = " + attempts);
    }

    @Step("INTAPI СlientStepsHelper: {method}")
    public <T> T createNewAgencySubClient(String base, String agencyLogin, Currency currency) {
        for (int i = 1; i <= attempts; i++) {
            try {
                log.info("Попытка создания клиента номер " + i);
                return clientSteps.createNewAgencySubClient(base, agencyLogin, currency);
            } catch (AxisError error) {
                assertThat("Не совпал код ошибки", ignoreErrorCodes, hasItemInArray(error.getErrorCode()));
            }
        }
        throw new DarkSideException("Не удалось создать клиента. Кол-во попыток = " + attempts);
    }

}
