package ru.yandex.autotests.directintapi.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.fakebsproxy.beans.updatestorecontent.*;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.CountryCurrencies;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.PriceInJson;
import ru.yandex.autotests.directapi.enums.AvailableActions;
import ru.yandex.autotests.directapi.enums.OSType;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

/**
 * Created by buhter on 01/09/15.
 */
public class StoreContentHelper {
    public static UpdateStoreContentMobileResponseBean getDefaultResponseBean(
            CountryCurrencies countryCurrencies
            , MobileContentRecord mobileContent) {
        UpdateStoreContentMobileResponseBean bean = new UpdateStoreContentMobileResponseBean();
        bean.setResponse(new Response());
        bean.getResponse().setResults(new ArrayList<>());
        bean.getResponse().getResults().add(new Result());
        bean.getResponse().getResults().get(0).setGroups(new ArrayList<>());
        bean.getResponse().getResults().get(0).getGroups().add(new Group());
        bean.getResponse().getResults().get(0).getGroups().get(0).setDocuments(new ArrayList<>());
        bean.getResponse().getResults().get(0).getGroups().get(0).getDocuments().add(new Document());
        Properties properties = new Properties()
                .withMimeType("")
                .withPrefix("")
                .withScreens("")
                .withReleaseDate("")
                .withDescription("")
                .withDescriptionSmall("")
                .withClickUrl("")
                .withDateReleaseTs("")
                .withWebsite("")
                .withPublisher("")
                .withmTime(new ArrayList<>())
                .withRating(mobileContent.getRating().toString())
                .withOsVersion(mobileContent.getMinOsVersion())
                .withName(mobileContent.getName())
                .withAdult(mobileContent.getAgeLabel().getLiteral())
                .withGenres(mobileContent.getGenre())
                .withAppId(mobileContent.getStoreContentId())
                .withFileSize(mobileContent.getAppSizeBytes().toString())
                .withRatingCount(mobileContent.getRatingVotes().toString());

        Type COMPLEX_MAP_TYPE = new TypeToken<Map<String, Map<String, JsonObject>>>() {
        }.getType();
        Map<String, Map<String, JsonObject>> dbPricesMap = new Gson().fromJson(mobileContent.getPricesJson()
                , COMPLEX_MAP_TYPE);
        Map<String, JsonObject> actionPricesMap = dbPricesMap.get(countryCurrencies.country());

        if (actionPricesMap != null) {
            PriceInJson priceInJson = new Gson().fromJson(actionPricesMap.get(AvailableActions.DOWNLOAD.toString())
                    , PriceInJson.class);
            properties.setCurrency(priceInJson.getPriceCurrency());
            properties.setPrice(priceInJson.getPrice());
        }

        if (mobileContent.getOsType().equals(OSType.ANDROID)) {
            properties.setId(mobileContent.getStoreContentId());
            if (mobileContent.getIconHash() != null && !mobileContent.getIconHash().equals("")) {
                properties.setIcon("http://avatars.mds.yandex.net/google-play-app-icon/"
                        + mobileContent.getIconHash() + " /orig");
            }
        } else {
            properties.setBundle(mobileContent.getBundleId());
            properties.setSupportedDevices("[\"iPadThirdGen4G\"" +
                    ", \"iPhone5s\"" +
                    ", \"iPadFourthGen\"" +
                    ", \"iPhone5c\"" +
                    ", \"iPhone6Plus\"" +
                    ", \"iPad2Wifi\"" +
                    ", \"iPad23G\"" +
                    ", \"iPhone-3GS\"" +
                    ", \"iPodTouchSixthGen\"" +
                    ", \"iPodTouchThirdGen\"" +
                    ", \"iPadMini4G\"" +
                    ", \"iPhone5\"" +
                    ", \"iPodTouchFourthGen\"" +
                    ", \"iPadThirdGen\"" +
                    ", \"iPhone4\"" +
                    ", \"iPad3G\"" +
                    ", \"iPodTouchFifthGen\"" +
                    ", \"iPhone4S\"" +
                    ", \"iPadWifi\"" +
                    ", \"iPhone6\"" +
                    ", \"iPadFourthGen4G\"" +
                    ", \"iPadMini\"]");
            if (mobileContent.getIconHash() != null && !mobileContent.getIconHash().equals("")) {
                properties.setIcon("http://avatars.mds.yandex.net/itunes-icon/"
                        + mobileContent.getIconHash() + " /orig");
            }
        }

        bean.getResponse().getResults().get(0).getGroups().get(0).getDocuments().get(0).setProperties(properties);
        return bean;
    }
}
