package ru.yandex.autotests.direct.integration.data.yabs.audit;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.List;

import static org.hamcrest.CoreMatchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 03.07.15.
 * Описание баннера в ответе аудита
 *    {
 *      "Retargetings" : [  ]     # список ретаргетингов баннера
 *      "ExportID" : "646605545",
 *      "BannerID" : "449518425",
 *      "Phrases" : [  ]          # список фраз баннера
 *      "Picture" : "yes",        # признак картинки
 *      "IsActive" : "yes"        # вкл/выкл пользователем или автобюджетом
 *    }
 */
public class AuditBannerBean {
    @Expose
    @SerializedName("ExportID")
    private Long exportId;

    @Expose
    @SerializedName("BannerID")
    private Long bannerId;

    @Expose
    @SerializedName("Picture")
    private String picture;

    @Expose
    @SerializedName("IsActive")
    private String isActive;

    @Expose
    @SerializedName("Phrases")
    private List<AuditPhraseBean> phrases;

    @Expose
    @SerializedName("Retargetings")
    private List<AuditRetargetingBean> retargetings;


    public Long getExportId() { return this.exportId; }

    public Long getBannerId() { return this.bannerId; }

    public String getPicture() { return this.picture; }

    public String getIsActive() { return this.isActive; }

    public List<AuditPhraseBean> getPhrases() { return  this.phrases; }

    public AuditPhraseBean getPhrase(Long phraseId) {
        AuditPhraseBean retPhrase = null;
        for (AuditPhraseBean phrase : getPhrases() ) {
            if (phrase.getPhraseId().equals(phraseId)) {
                retPhrase = phrase;
                break;
            }
        }
        assumeThat("баннер (bannerId="+ this.bannerId + ") содержит фразу (phraseId=" + phraseId + ")",
                retPhrase, notNullValue());
        return retPhrase;
    }

    public AuditPhraseBean getPhraseByEid(Long id) {
        AuditPhraseBean retPhrase = null;
        for (AuditPhraseBean phrase : getPhrases() ) {
            if (phrase.getId().equals(id)) {
                retPhrase = phrase;
                break;
            }
        }
        assumeThat("баннер (bannerId="+ this.bannerId + ") содержит фразу (Id=" + id + ")",
                retPhrase, notNullValue());
        return retPhrase;
    }

    public List<AuditRetargetingBean> getRetargetings() {return  this.retargetings;}

    public AuditRetargetingBean getRetargeting(Long retGoalContextId) {
        AuditRetargetingBean retRetargeting = null;
        for (AuditRetargetingBean retargeting : getRetargetings() ){
            if (retargeting.getGoalContextId().equals(retGoalContextId)) {
                retRetargeting = retargeting;
                break;
            }
        }
        assumeThat("баннер (bannerId="+ this.bannerId + ") содержит ретаргетинг (goalContextId=" + retGoalContextId + ")",
                retRetargeting, notNullValue());
        return retRetargeting;
    }


    public AuditBannerBean withExportId(Long exportId) {
        this.exportId = exportId;
        return this;
    }

    public AuditBannerBean withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public AuditBannerBean withPicture(String picture) {
        this.picture = picture;
        return this;
    }

    public AuditBannerBean withIsActive(String isActive) {
        this.isActive = isActive;
        return this;
    }

    public AuditBannerBean withPhrases(List<AuditPhraseBean> phrases) {
        this.phrases = phrases;
        return this;
    }

    public AuditBannerBean withRetargetings(List<AuditRetargetingBean> retargetings) {
        this.retargetings = retargetings;
        return this;
    }


}
