package ru.yandex.autotests.direct.integration.data.yabs.audit;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import static org.hamcrest.CoreMatchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * Created by pashkus on 03.07.15.
 * Параметры заказа в ответе аудита
 * {
 *    "Sum" : "2270000000",             # сумма всех зачислений
 *    "ExportID" : "11070321",
 *    "BaseUpdateTime" : "1436536694",  # время генерации dbm базы
 *    "CurrencyID" : "643",             # код валюты заказа
 *    "IsActive" : "yes",               # статус открутки; учитывает остановку пользователем, остаток и время завершения
 *    "OrderID" : "4368751",
 *    "Balance" : "1922000",            # остаток с учетом единого счета
 *    "Banners" : [ ... ]               # список всех баннеров заказа
 * }
 */

public class AuditOrderResponse {

    @Expose
    @SerializedName("ExportID")
    private Long exportId;

    @Expose
    @SerializedName("OrderID")
    private Long orderId;

    @Expose
    @SerializedName("CurrencyID")
    private Integer currencyId;

    @Expose
    @SerializedName("Balance")
    private Long balance;

    @Expose
    @SerializedName("IsActive")
    private String isActive;
    //TODO сделать свой перечисляемый тип и преобразовывать статусы в него

    @Expose
    @SerializedName("BaseUpdateTime")
    private Long baseUpdateTime;
    //TODO приобразовывать в Date

    @Expose
    @SerializedName("Banners")
    private List<AuditBannerBean> banners;


    public Long getExportId() { return this.exportId; }

    public Long getOrderId() { return this.orderId; }

    public Integer getCurrencyId() { return this.currencyId; }

    public Long getBalance() { return this.balance; }

    public String getIsActive() { return this.isActive; }

    public Long getBaseUpdateTime() { return  this.baseUpdateTime; }

    public List<AuditBannerBean> getBanners() {
        return  this.banners;
    }

    public AuditBannerBean getBanner( Long bannerId ) {

        AuditBannerBean retBanner = null;
        for (AuditBannerBean banner : getBanners() ) {
            if (banner.getBannerId().equals(bannerId)) {
                retBanner = banner;
                break;
            }
        }
        assumeThat("баннер с banenrId=" + bannerId + " существует", retBanner, notNullValue());
        return retBanner;
    }

    public boolean addBanner( AuditBannerBean banner) {
        return banners.add(banner);
    }

    public AuditBannerBean getBannerByEid( Long exportId ){
        AuditBannerBean retBanner = null;
        for (AuditBannerBean banner : getBanners() ) {
            if (banner.getExportId().equals(exportId)) {
                retBanner = banner;
                break;
            }
        }
        assumeThat("баннер с exportId=" + exportId + " существует", retBanner, notNullValue());
        return retBanner;
    }

    public AuditOrderResponse withExportId(Long exportId) {
        this.exportId = exportId;
        return this;
    }

    public AuditOrderResponse withOrderId(Long orderId) {
        this.orderId = orderId;
        return this;
    }

    public AuditOrderResponse withCurrencyId(Integer currencyId) {
        this.currencyId = currencyId;
        return this;
    }

    public AuditOrderResponse withBalance(Long balance) {
        this.balance = balance;
        return this;
    }

    public AuditOrderResponse withIsActive(String isActive) {
        this.isActive = isActive;
        return this;
    }

    public AuditOrderResponse withBaseUpdateTime(Long baseUpdateTime) {
        this.baseUpdateTime = baseUpdateTime;
        return this;
    }

    public AuditOrderResponse withBanners( List<AuditBannerBean> banners ) {
        this.banners = banners;
        return this;
    }
}
