package ru.yandex.autotests.direct.integration.data.yabs.audit;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by pashkus on 03.07.15.
 * Класс описывает фразу в ответе аудита
 * "Phrases" : [
 *        {
 *        "ContextPrice" : "10000000",
 *        "BaseUpdateTime" : "1436535312",    #время генерации st-базы
 *        "PhraseID" : "497193217",           #id фразы в БК
 *        "DataMD5" : "7363315812254551489",  #хеш-сумма от текста фразы и типа фразы
 *        "Price" : "300000",
 *        "IsActive" : "yes",                 #признак включенности фразы пользователем
 *        "IsRubric" : "no"                   #является ли фраза категорией каталога (устар.)
 *        }
 *  и хранит id фразы в директе
 */
public class AuditPhraseBean {
    //это костыль, но без него не обойтись
    @Expose
    private Long id = null;

    @Expose
    @SerializedName("PhraseID")
    private Long phraseId;

    @Expose
    @SerializedName("DataMD5")
    private String dataMd5;

    @Expose
    @SerializedName("Price")
    private Integer price;

    @Expose
    @SerializedName("ContextPrice")
    private Integer contextPrice;

    @Expose
    @SerializedName("IsActive")
    private String isActive;

    @Expose
    @SerializedName("IsRubric")
    private String isRubric;

    @Expose
    @SerializedName("BaseUpdateTime")
    private Long baseUpdateTime;

    public Long getId() {return this.id; }

    public Long getPhraseId() {
        return this.phraseId;
    }

    public String getDataMd5() {
        return this.dataMd5;
    }

    public Integer getPrice() {
        return this.price;
    }

    public Integer getContextPrice() {
        return this.contextPrice;
    }

    public String getIsActive() {
        return this.isActive;
    }

    public String getIsRubric() {
        return this.isRubric;
    }

    public Long getBaseUpdateTime() {
        return this.baseUpdateTime;
    }


    public AuditPhraseBean withId(Long id ){
        this.id = id;
        return this;
    }

    public AuditPhraseBean withPhraseId(Long phraseId) {
        this.phraseId = phraseId;
        return this;
    }

    public AuditPhraseBean withDataMd5(String dataMd5) {
        this.dataMd5 = dataMd5;
        return this;
    }

    public AuditPhraseBean withPrice(Integer price) {
        this.price = price;
        return this;
    }

    public AuditPhraseBean withContextPrice(Integer contextPrice) {
        this.contextPrice = contextPrice;
        return this;
    }

    public AuditPhraseBean withIsActive(String isActive) {
        this.isActive = isActive;
        return this;
    }

    public AuditPhraseBean withIsRubric(String isRubric) {
        this.isRubric = isRubric;
        return this;
    }

    public AuditPhraseBean withBaseUpdateTime(Long baseUpdateTime) {
        this.baseUpdateTime = baseUpdateTime;
        return this;
    }
}
