package ru.yandex.autotests.direct.integration.data.yabs.audit;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by pashkus on 03.07.15.
 * Класс описывает ретаргетинг в ответе аудита
 *
 * { "GoalContextID":"189922",
 *   "IsActive":"no",
 *   "ContextPrice":"300000"
 * }
 */
public class AuditRetargetingBean {

    @Expose
    @SerializedName("GoalContextID")
    private Long goalContextId;

    @Expose
    @SerializedName("IsActive")
    private String isActive;

    @Expose
    @SerializedName("ContextPrice")
    private Integer contextPrice;


    public Long getGoalContextId() { return this.goalContextId; }

    public Integer getContextPrice() { return this.contextPrice; }

    public String getIsActive() { return this.isActive; }


    public AuditRetargetingBean withGoalContextId(Long goalContextId) {
        this.goalContextId = goalContextId;
        return this;
    }

    public AuditRetargetingBean withContextPrice(Integer contextPrice) {
        this.contextPrice = contextPrice;
        return this;
    }

    public AuditRetargetingBean withIsActive(String isActive) {
        this.isActive = isActive;
        return this;
    }

}
