package ru.yandex.autotests.direct.integration.data.yabs.page;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.List;

/**
 * Created by pashkus on 11.02.16.
 * Describes subobject "add_info" of PageBannerBean
 * Example of bsserver response with block "add_info": https://paste.yandex-team.ru/98549
 */
public class PageBannerAdditionsBean {
    @Expose
    @SerializedName("callouts_list")
    private List<String> calloutsList;

    @Expose
    @SerializedName("type")
    private String type;

    public PageBannerAdditionsBean withCalloutsList(List<String> calloutsList) {
        this.calloutsList = calloutsList;
        return this;
    }

    public PageBannerAdditionsBean withType(String type) {
        this.type = type;
        return this;
    }

    public List<String> getCalloutsList() {
        return calloutsList;
    }

    public String getType() {
        return type;
    }
}
