package ru.yandex.autotests.direct.integration.data.yabs.page;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;

/**
 * Created by pashkus on 22.12.15.
 * Describes banner object in lists "direct_premium", "direct_halfpremium"
 *
 * {
 * "stat" : [ PageStatisticsBean, ... ],
 * "direct_halfpremium": [ PageBannerBean, ... ],
 * "direct_premium" :  [ PageBannerBean, ... ]
 * }
 * Example: https://paste.yandex-team.ru/94257
 */
public class PageBannerBean {

    @Expose
    @SerializedName("link_tail")
    private String linkTail;

    @Expose
    @SerializedName("url")
    private String url;

    @Expose
    @SerializedName("no_redirect_url")
    private String noRedirectUrl;

    @Expose
    @SerializedName("title")
    private String title;

    @Expose
    @SerializedName("body")
    private String body;

    @Expose
    @SerializedName("domain")
    private String domain;

    @Expose
    @SerializedName("fav_domain")
    private String favDomain;

    @Expose
    @SerializedName("block_favicon")
    private String blockFavicon;

    @Expose
    @SerializedName("region")
    private String region;

    @Expose
    @SerializedName("warning")
    private String warning;

    @Expose
    @SerializedName("debug")
    private String debug;

    @Expose
    @SerializedName("bid")
    private Long bannerId;

    @Expose
    @SerializedName("subway_station")
    public String subwayStationId;

    @Expose
    @SerializedName("working_time")
    public String workingTime;

    @Expose
    @SerializedName("vcard_url")
    public String vcardUrl;

    @Expose
    @SerializedName("call_url")
    public String callUrl;

    @Expose
    @SerializedName("order_type")
    private String orderType;

    @Expose
    @SerializedName("age")
    private String age;

    @Expose
    @SerializedName("phone")
    private String phone;

    @Expose
    @SerializedName("sitelinks")
    private List<PageBannerSitelinksBean> sitelinks;

    @Expose
    @SerializedName("add_info")
    private PageBannerAdditionsBean additons;

    @Expose
    @SerializedName("ratings")
    private HashMap<String, String> ratings;

    @Expose
    @SerializedName("prediction")
    //private HashMap<String, Float> prediction;
    private String prediciton;


    public Long getBannerId() {
        return bannerId;
    }

    public String getAge() {
        return age;
    }

    public String getBody() {
        return body;
    }

    public String getDomain() {
        return domain;
    }

    public String getFavDomain() {
        return favDomain;
    }

    public String getTitle() {
        return title;
    }

    public String getBlockFavicon() {
        return blockFavicon;
    }

    public String getPhone() {
        return phone;
    }

    public String getNoRedirectUrl() {
        return noRedirectUrl;
    }

    public String getUrl() {
        return url;
    }

    public String getVcardUrl() {
        return vcardUrl;
    }

    public String getCallUrl() {
        return callUrl;
    }

    public String getWorkingTime() {
        return workingTime;
    }

    public String getOrderType() {
        return orderType;
    }

    public String getSubwayStationId() {
        return subwayStationId;
    }

    public String getRegion() {
        return region;
    }

    public String getDebug() {
        return debug;
    }

    public String getWarning() {
        return warning;
    }

    public String getLinkTail() {
        return linkTail;
    }

//    public HashMap<String, Float> getPrediction() {
//        return prediction;
//    }

    public String getPrediciton() {
        return prediciton;
    }

    public HashMap<String, String> getRatings() {
        return ratings;
    }

    public List<PageBannerSitelinksBean> getSitelinks() {
        return sitelinks;
    }

    public PageBannerAdditionsBean getAdditons() {
        return additons;
    }

    public PageBannerBean withAdditons(PageBannerAdditionsBean additons) {
        this.additons = additons;
        return this;
    }

    public PageBannerBean withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public PageBannerBean withBody(String body) {
        this.body = body;
        return this;
    }

    public PageBannerBean withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public PageBannerBean withTitle(String title) {
        this.title = title;
        return this;
    }

    public PageBannerBean withSitelinks(List<PageBannerSitelinksBean> sitelinks) {
        this.sitelinks = sitelinks;
        return this;
    }

    public PageBannerBean withUrl(String url) {
        this.url = url;
        return this;
    }
}
