package ru.yandex.autotests.direct.integration.data.yabs.page;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by pashkus on 22.12.15.
 * Describes subobject "sitelinks" in PageBannerBean:
 * PageBannerBean:
 *    {
 *        ...,
 *        PageSiteLinks,
 *        ...
 *    },
 * Look at "sitelinks" in page response
 */
public class PageBannerSitelinksBean {

    @Expose
    @SerializedName("title")
    public String title;

    @Expose
    @SerializedName("url")
    public String url;

    @Expose
    @SerializedName("noredirect_url")
    public String noredirectUrl;

    @Expose
    @SerializedName("text")
    public String text;

    public String getTitle() {
        return title;
    }

    public String getUrl() {
        return url;
    }

    public String getNoredirectUrl() {
        return noredirectUrl;
    }

    public String getText() {
        return text;
    }

    public PageBannerSitelinksBean withTitle(String title) {
        this.title = title;
        return this;
    }

    public PageBannerSitelinksBean withUrl(String url) {
        this.url = url;
        return this;
    }

    public PageBannerSitelinksBean withNoredirectUrl(String noredirectUrl) {
        this.noredirectUrl = noredirectUrl;
        return this;
    }

    public PageBannerSitelinksBean withText(String text) {
        this.text = text;
        return this;
    }
}
