package ru.yandex.autotests.direct.integration.data.yabs.page;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by pashkus on 22.12.15.
 */

/**@
 * Response of pageId 3933.  Consist of dictionary of dictionaries
 * Format: 1) json object  2) without //yandex-splitter
 * Example: https://paste.yandex-team.ru/94257
 * {
 * "stat" : [ PageStatisticsBean, ... ],
 * "direct_halfpremium": [PageBannerBean],
 * "direct_premium" :  [ PageBannerBean, ... ]
 * }
 */

public class PageResponse {

    @Expose
    @SerializedName("stat")
    public List<PageStatisticsBean> stat;    // по факту тут всегда один элемент

    @Expose
    @SerializedName("direct_halfpremium")
    public List<PageBannerBean> halfPremium; // список баннеров в гарантии

    @Expose
    @SerializedName("direct_premium")
    public List<PageBannerBean> premium;     // список баннеров в спецразмещении


    public List<PageStatisticsBean> getStat() {
        return stat;
    }

    public List<PageBannerBean> getHalfPremium() {
        return halfPremium;
    }

    public List<PageBannerBean> getPremium() {
        return (premium == null)? new ArrayList<PageBannerBean>() : premium;
    }

    public PageResponse withStat(List<PageStatisticsBean> stat) {
        this.stat = stat;
        return this;
    }

    public PageResponse withHalfPremium(List<PageBannerBean> halfPremium) {
        this.halfPremium = halfPremium;
        return this;
    }

    public PageResponse withPremium(List<PageBannerBean> premium) {
        this.premium = premium;
        return this;
    }


    /**@
     * Find banner with such bannerId in Premium block
     * @param bsBannerId - bannerId in BS
     * @return PageBannerBean or null
     */
    public PageBannerBean getBannerFromPremium(Long bsBannerId){
        PageBannerBean retBanner = null;
        for ( PageBannerBean banner : getPremium() ) {
            if ( banner.getBannerId() == (long) bsBannerId ) {
                retBanner = banner;
            }
        }
        return retBanner;
    }

    /**@
     * Find banner with such bannerId in HalfPremium(Guarantee) block
     * @param bsBannerId - bannerId in BS
     * @return PageBannerBean or null
     */
    public PageBannerBean getBannerFromHalfPremium(Long bsBannerId){
        PageBannerBean retBanner = null;
        for ( PageBannerBean banner : getHalfPremium() ) {
            if ( banner.getBannerId() == (long) bsBannerId ) {
                retBanner = banner;
            }
        }
        return retBanner;
    }


}
