package ru.yandex.autotests.direct.integration.data.yabs.page;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * Created by pashkus on 22.12.15.
 * Describes block of statistics in page response
 * {
 * "stat" : [ PageStatisticsBean, ... ],
 * ...
 * }
 */
public class PageStatisticsBean {

    @Expose
    @SerializedName("direct_premium")
    public Integer directPremium;

    @Expose
    @SerializedName("direct_guarantee")
    public Integer directGuarantee;

    @Expose
    @SerializedName("direct_dynamic")
    public Integer directDynamic;

    @Expose
    @SerializedName("bs_blockid")
    public String bsBlockId;

    @Expose
    @SerializedName("tragic")
    public String tragic;

    @Expose
    @SerializedName("link_head")
    public String linkHead;

    @Expose
    @SerializedName("bs_counter")
    public String bsCounter;

    @Expose
    @SerializedName("clid_type")
    public String clidType;

    @Expose
    @SerializedName("expbucket")
    public String expbucket;

    public Integer getDirectPremium() {
        return directPremium;
    }

    public Integer getDirectDynamic() {
        return directDynamic;
    }

    public Integer getDirectGuarantee() {
        return directGuarantee;
    }

    public String getTragic() {
        return tragic;
    }

    public String getBsBlockId() {
        return bsBlockId;
    }

    public String getBsCounter() {
        return bsCounter;
    }

    public String getClidType() {
        return clidType;
    }

    public String getExpbucket() {
        return expbucket;
    }

    public String getLinkHead() {
        return linkHead;
    }


    public PageStatisticsBean withBsBlockId(String bsBlockId) {
        this.bsBlockId = bsBlockId;
        return this;
    }

    public PageStatisticsBean withBsCounter(String bsCounter) {
        this.bsCounter = bsCounter;
        return this;
    }

    public PageStatisticsBean withClidType(String clidType) {
        this.clidType = clidType;
        return this;
    }

    public PageStatisticsBean withDirectDynamic(Integer directDynamic) {
        this.directDynamic = directDynamic;
        return this;
    }

    public PageStatisticsBean withDirectGuarantee(Integer directGuarantee) {
        this.directGuarantee = directGuarantee;
        return this;
    }

    public PageStatisticsBean withDirectPremium(Integer directPremium) {
        this.directPremium = directPremium;
        return this;
    }

    public PageStatisticsBean withExpbucket(String expbucket) {
        this.expbucket = expbucket;
        return this;
    }

    public PageStatisticsBean withLinkHead(String linkHead) {
        this.linkHead = linkHead;
        return this;
    }

    public PageStatisticsBean withTragic(String tragic) {
        this.tragic = tragic;
        return this;
    }
}
