package ru.yandex.autotests.direct.integration.httpclient;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import ru.yandex.autotests.direct.integration.YabsProperties;
import ru.yandex.autotests.direct.integration.steps.YabsServerSteps;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by pashkus on 25.02.16.
 * Класс описывает параметры запроса в движок баннерокрутилки
 */
public class BsServerRequest {

    private List<NameValuePair> requestParams;
    private List<NameValuePair> headers;

    private String requestPath;


    public BsServerRequest() {
        requestParams = new ArrayList<>();
        headers = new ArrayList<>();
        withDefaultHeaders();
    }


    public BsServerRequest withDefaultHeaders() {
        headers.add(new BasicNameValuePair("Host", YabsProperties.getInstance().getAuditHeaderHost()));
        return this;
    }

    public BsServerRequest withRegId(Integer regionId){
        requestParams.add(new BasicNameValuePair("reg-id", regionId.toString()));
        return this;
    }

    public BsServerRequest withTuneRegionId(Integer regionId){
        requestParams.add(new BasicNameValuePair("tune-region-id", regionId.toString()));
        return this;
    }

    public BsServerRequest withText(String phraseText ){
        requestParams.add(new BasicNameValuePair("text", phraseText));
        return this;
    }

    public BsServerRequest withDirectPic(Boolean showPicBanners ){
        requestParams.add(new BasicNameValuePair("directpic", showPicBanners.toString()));
        return this;
    }

    public BsServerRequest withRequestType(YabsServerSteps.RequestPath reqPath, YabsServerSteps.PageNumber pageId) {
        requestPath = "/" + reqPath.toString() + "/" + pageId.toString();
        return this;
    }

    /**
     * Метод задает регион определяемый из поискового запроса пользователя
     * Подробнее: https://st.yandex-team.ru/QABS-4587
     * (Например, для запроса "гостиницы в москве" в relev-factors будет передаваться gc=213)
     * @param regionId код региона из поискового запроса
     * @return
     */
    public BsServerRequest withExtendedRegId(Integer regionId) {
        requestParams.add(new BasicNameValuePair("relev-factors", "gc=" + regionId.toString()));
        return this;
    }

    public List<NameValuePair> getRequestParams() {
        return requestParams;
    }

    public String getRequestPath() {
        return requestPath;
    }
}
