package ru.yandex.autotests.direct.integration.httpclient;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import ru.yandex.autotests.direct.integration.data.yabs.audit.AuditOrderResponse;
import ru.yandex.autotests.direct.integration.data.yabs.page.PageResponse;
import ru.yandex.autotests.httpclient.lite.core.BackEndResponse;

import java.lang.reflect.Type;
import java.util.List;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 22.12.15.
 * Handles various types of bsserver responses
 * Contains methods asYabsPageBeans(), asAuditBeans() to convert to PageResponse and AuditOrderResponse accordingly
 */
public class BsServerResponse extends BackEndResponse {

    public BsServerResponse(StatusLine statusLine, HttpEntity httpEntity, Header[] headers) {
        super(statusLine, httpEntity, headers);
    }

    public PageResponse asYabsPageBeans() {
        Type type = new TypeToken<PageResponse>() {}.getType();
        Gson gson = new Gson();

        PageResponse response = gson.fromJson( getResponseContent().toString(), type);
        return response;
    }

    public AuditOrderResponse asAuditBeans(){
        Type type = new TypeToken<List<AuditOrderResponse>>() {}.getType();
        Gson gson = new Gson();

        List<AuditOrderResponse> orderBean = gson.fromJson( getResponseContent().toString(), type);
        assumeThat("ответ аудита содержит один заказ", orderBean.size(), equalTo(1));
        return (orderBean.size() > 0) ? orderBean.get(0) : null;
    }
}
