package ru.yandex.autotests.direct.integration.httpclient;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.BufferedHttpEntity;
import ru.yandex.autotests.httpclient.lite.core.exceptions.BackEndClientException;

import java.io.IOException;

/**
 * Created by pashkus on 21.01.16.
 */
public class BsServerResponseHandler implements ResponseHandler<BsServerResponse> {

    @Override
    public BsServerResponse handleResponse(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if(statusLine.getStatusCode() > 400) {
            throw new BackEndClientException("Server returned error " +
                    statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
        }
        HttpEntity entity = new BufferedHttpEntity(response.getEntity());

        return new BsServerResponse(statusLine, entity, response.getAllHeaders());
    }

}
