package ru.yandex.autotests.direct.intapi.java;

import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

@Resource.Classpath("direct.java.intapi.properties")
public class DirectJavaIntapiProperties {

    private static DirectJavaIntapiProperties properties = null;

    @Property("direct.java.intapi.verbose")
    protected boolean verbose = false;


    private DirectJavaIntapiProperties() {
        PropertyLoader.populate(this);
    }

    public static DirectJavaIntapiProperties getInstance() {
        if (properties == null) {
            properties = new DirectJavaIntapiProperties();
        }

        return properties;
    }

    public boolean isVerbose() {
        return verbose;
    }
}
