package ru.yandex.autotests.direct.intapi.java.core;

import java.util.function.Supplier;

import ru.yandex.autotests.direct.intapi.client.ApiClient;
import ru.yandex.autotests.direct.intapi.java.DirectJavaIntapiProperties;
import ru.yandex.autotests.direct.utils.clients.tvm.ServiceTicketProvider;
import ru.yandex.autotests.direct.utils.clients.tvm.ServiceTicketProviderProxy;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;

public class DirectJavaIntapiStepsContext {
    private DirectTestRunProperties properties;
    private ApiClient client;

    public DirectJavaIntapiStepsContext withProperties(DirectTestRunProperties properties) {
        this.properties = properties;
        return this;
    }

    public ApiClient getApiClient() {
        if (client == null) {
            ServiceTicketProvider serviceTicketProvider = new ServiceTicketProviderProxy();
            Supplier<String> ticketProvider =
                    () -> serviceTicketProvider.getServiceTicket(properties.getDirectIntapiTvmClientId());

            client = ApiClient.Builder.create()
                    .baseUrl(properties.getDirectIntapiJavaHost())
                    .verbose(DirectJavaIntapiProperties.getInstance().isVerbose())
                    .tvmTicketProvider(ticketProvider)
                    .build();
        }
        return client;
    }
}
