package ru.yandex.autotests.direct.intapi.java.steps;

import java.util.List;

import ru.yandex.autotests.direct.intapi.MetrikaexportcontrollerApi;
import ru.yandex.autotests.direct.intapi.java.core.DirectJavaIntapiBaseSteps;
import ru.yandex.autotests.direct.intapi.models.MetrikaBannersParam;
import ru.yandex.autotests.direct.intapi.models.MetrikaBannersResult;
import ru.yandex.autotests.direct.intapi.models.MetrikaCampaignsResult;
import ru.yandex.autotests.direct.intapi.models.MetrikaCountersResult;
import ru.yandex.autotests.direct.intapi.models.MetrikaDynamicsParam;
import ru.yandex.autotests.direct.intapi.models.MetrikaDynamicsResult;
import ru.yandex.autotests.direct.intapi.models.MetrikaGroupsParam;
import ru.yandex.autotests.direct.intapi.models.MetrikaGroupsResult;
import ru.yandex.autotests.direct.intapi.models.MetrikaPerformanceFiltersParam;
import ru.yandex.autotests.direct.intapi.models.MetrikaPerformanceFiltersResult;
import ru.yandex.qatools.allure.annotations.Step;

public class MetrikaExportControllerSteps extends DirectJavaIntapiBaseSteps<MetrikaexportcontrollerApi> {
    public MetrikaExportControllerSteps() {
        super(MetrikaexportcontrollerApi.class);
    }

    @Step("Metrika: запрос metrika-export/banners")
    public List<MetrikaBannersResult> getBanners(List<MetrikaBannersParam> params) {
        return executeSafe(getApiService().getBanners(params)).body();
    }

    @Step("Metrika: запрос metrika-export/campaigns")
    public List<MetrikaCampaignsResult> getCampaigns(List<Long> orderIds) {
        return executeSafe(getApiService().getCampaigns(orderIds)).body();
    }

    @Step("Metrika: запрос metrika-export/metrika-counters")
    public List<MetrikaCountersResult> getCampCounters(Long divisor, Long reminder) {
        return executeSafe(getApiService().getCampCounters(divisor, reminder)).body();
    }

    @Step("Metrika: запрос metrika-export/dynamics")
    public List<MetrikaDynamicsResult> getDynamics(List<MetrikaDynamicsParam> params) {
        return executeSafe(getApiService().getDynamics(params)).body();
    }

    @Step("Metrika: запрос metrika-export/groups")
    public List<MetrikaGroupsResult> getGroups(List<MetrikaGroupsParam> params) {
        return executeSafe(getApiService().getGroups(params)).body();
    }

    @Step("Metrika: запрос metrika-export/performance-filters")
    public List<MetrikaPerformanceFiltersResult> getPerformanceFilters(List<MetrikaPerformanceFiltersParam> params) {
        return executeSafe(getApiService().getPerformanceFilters(params)).body();
    }

    @Step("Metrika: запрос metrika-export/retargeting-goals")
    public List<Long> getRetargetingGoals(Long divisor, Long reminder) {
        return executeSafe(getApiService().getRetargetingGoals(divisor, reminder)).body();
    }
}
