package ru.yandex.autotests.direct.analyzer;

import ru.yandex.autotests.direct.analyzer.common.ShellHelper;
import ru.yandex.autotests.direct.analyzer.lexer.LexemReader;
import ru.yandex.autotests.direct.analyzer.perl.PerlAnalyzer;
import ru.yandex.autotests.direct.analyzer.perl.PerlModule;
import ru.yandex.autotests.direct.analyzer.svndiff.ChangesHelper;
import ru.yandex.autotests.direct.analyzer.svndiff.FileDiff;
import ru.yandex.autotests.direct.analyzer.svndiff.FileParser;
import ru.yandex.autotests.direct.analyzer.tree.*;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import static ru.yandex.autotests.direct.analyzer.matcher.StartWithUpperCaseLetter.startWithUpperCase;
import static org.hamcrest.Matchers.*;

/**
 * Created by alexey-n on 17.11.14.
 */
public class Main {

    private static String DIRECT_SOURCE;// = "/Users/alexey-n/Documents/direct-src-2/direct/trunk/";
    private static String BASE_DIR;// = "/Users/alexey-n/Documents/CallFunctionGraph/call-function-graph/src/main/resources/perl/";
    private static String JSON_PATH;// = "/Users/alexey-n/Documents/CallFunctionGraph/call-function-graph/src/main/resources/perl/json/";
    private static String SVN_DIFF;// = "/Users/alexey-n/svndiff.txt";
    private static String OUTPUT_FILE;// = "/Users/alexey-n/Downloads/d3/output.json";
    private static String RUNSH_PATH;// = "/Users/alexey-n/Documents/CallFunctionGraph/call-function-graph/src/main/resources/run.sh";
    public static boolean DEBUG = false;

    public static void main(String[] args) {
        DIRECT_SOURCE = args[0];
        BASE_DIR = args[1];
        SVN_DIFF = args[2];
        OUTPUT_FILE = args[3];
        RUNSH_PATH = args[4];

        JSON_PATH = BASE_DIR + "json/";

        Collection<File> files = getFilesList(DIRECT_SOURCE);
        Collection<File> jsonFiles = generateLexemJson(files);

        Map<String, PerlModule> modules = PerlAnalyzer.analyze(LexemReader.readLexemsFromJson(jsonFiles, JSON_PATH));

        List<FileDiff> fileDiffs = FileParser.parseSvnDiff(new File(SVN_DIFF));

        ChangesHelper.detectChangedFunctions(fileDiffs, modules);

        FunctionTreeBuilder builder = new FunctionTreeBuilder(modules);
        builder.withNode("Backend")
                .withCombineType(CombineType.AND)
                .withFunctionName(startsWith("cmd_"))
                .withModuleName(startsWith("DoCmd"));
        builder.withNode("API")
                .withCombineType(CombineType.XOR)
                .withFunctionName(allOf(startWithUpperCase(), not(startsWith("_"))))
                .withFunctionNameFormat(FunctionNameFormat.PACKAGE_AND_NAME)
                .withModuleName(startsWith("APIMethods"))
                .withPackageName(startsWith("protected::API::Methods"));
        builder.withNode("PPC Scripts")
                .withCombineType(CombineType.AND)
                .withFunctionNameFormat(FunctionNameFormat.PACKAGE_AND_NAME)
                .withModuleName(startsWith("ppc"))
                .withPackageName(equalTo("protected"));
        builder.withNode("Export")
                .withCombineType(CombineType.AND)
                .withFunctionName(equalTo("handler"))
                .withFunctionNameFormat(FunctionNameFormat.PACKAGE_AND_NAME)
                .withPackageName(startsWith("protected::Export"));
        builder.withNode("Intapi")
                .withCombineType(CombineType.AND)
                .withFunctionNameFormat(FunctionNameFormat.PACKAGE_AND_NAME)
                .withPackageName(startsWith("protected::Intapi"));
        builder.withNode("BsExport")
                .withCombineType(CombineType.AND)
                .withModuleName(anyOf(containsString("bsClientData"), containsString("bsClientMedia"),
                        containsString("bsCampSums"), containsString("bsExportMaster")))
                .withFunctionNameFormat(FunctionNameFormat.PACKAGE_AND_NAME)
                .withPackageName(startsWith("protected::BS"));
        builder.withNode("Sandbox")
                .withCombineType(CombineType.XOR)
                .withModuleName(anyOf(containsString("SandboxCommon"), containsString("SandboxClient")))
                .withFunctionNameFormat(FunctionNameFormat.PACKAGE_AND_NAME)
                .withPackageName(startsWith("protected::Sandbox"));
        builder.withNode("APIv5")
                .withCombineType(CombineType.AND)
                .withPackageName(startsWith("api::services::v5::API"));
        FunctionTree functionTree = builder.build();

        TreeHelper.recoursiveTreeSort(functionTree);
        for(FunctionTree node:functionTree.getChildren()) {
            TreeHelper.removeUnchanged(node);
        }
        for(FunctionTree node:functionTree.getChildren()) {
            if(node == null || node.getChildren() == null) {
                continue;
            }
            if (node.getChildren().size() == 0) {
                node.setChildren(null);
            }
        }
        TreeWriter.writeTree(OUTPUT_FILE, functionTree);
        System.out.println("finish");
    }

    public static Collection<File> generateLexemJson(Collection<File> files) {
        List<File> result = new ArrayList<File>();
        for (File file : files) {
            String newFileName = file.getAbsolutePath().replace(DIRECT_SOURCE,
                    JSON_PATH) + ".json";
            generateJsonFromSource(file.getAbsolutePath(), newFileName);
            result.add(new File(newFileName));
        }
        return result;
    }

    public static void generateJsonFromSource(String fileName, String parsedFileName) {
        String[] commandWithArgs = new String[4];
        commandWithArgs[0] = RUNSH_PATH;
        commandWithArgs[1] = BASE_DIR;
        commandWithArgs[2] = fileName;
        commandWithArgs[3] = parsedFileName;
        ShellHelper.executeCommand(commandWithArgs);
        System.out.println(parsedFileName);
    }

    public static Collection<File> getFilesList(String baseDir) {
        Collection<File> all = new ArrayList<File>();
        addTree(new File(baseDir), all);
        return all;
    }

    private static void addTree(File file, Collection<File> all) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isFile() && (child.getName().endsWith(".pm") || child.getName().endsWith(".pl"))) {
                    all.add(child);
                }
                addTree(child, all);
            }
        }
    }
}
