package ru.yandex.autotests.direct.analyzer.graph;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by alexey-n on 18.11.14.
 */
public class Graph {

    private List<Node> nodes;
    private List<Edge> edges;

    public Graph() {
        nodes = new ArrayList<Node>();
        edges = new ArrayList<Edge>();
    }

    public List<Node> getNodes() {
        return nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public List<Edge> getEdges() {
        return edges;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public void addEdge(Edge edge) {
        edge.setId("E" + String.valueOf(edges.size()));
        edges.add(edge);
    }

    public String addNode(Node node) {
        String nodeId = "N" + String.valueOf(nodes.size());
        node.setId(nodeId);
        nodes.add(node);
        return nodeId;
    }
}
