package ru.yandex.autotests.direct.analyzer.lexer;

import ru.yandex.autotests.direct.analyzer.perl.PerlModule;
import ru.yandex.autotests.direct.analyzer.perl.analyzer.FiniteStateMachine;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

import java.io.*;
import java.util.*;

/**
 * Created by alexey-n on 22.01.15.
 */
public class LexemReader {

    public static Map<String, List<Lexem>> readLexemsFromJson(Collection<File> jsonFiles, String jsonBasePath) {
        ObjectMapper mapper = new ObjectMapper();

        Map<String, List<Lexem>> lexemMap = new HashMap<String, List<Lexem>>();
        try {
            for (File file : jsonFiles) {
                List<Lexem> lexems = mapper.readValue(file, new TypeReference<List<Lexem>>() {
                });
                String pack = file.getAbsolutePath().replace(jsonBasePath, "");
                pack = pack.replace(".json", "").replace(".pm", "").replace(".pl", "").replaceAll("/", "::");
                lexemMap.put(pack, lexems);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return lexemMap;
    }
}
