package ru.yandex.autotests.direct.analyzer.matcher;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/**
 * Created by alexey-n on 22.01.15.
 */

public class StartWithUpperCaseLetter extends TypeSafeMatcher<String> {

    public StartWithUpperCaseLetter() {
    }

    public boolean matchesSafely(String item) {
        return item.substring(0,1).equals(item.substring(0, 1).toUpperCase());
    }

    public void describeMismatchSafely(String item, Description mismatchDescription) {
        mismatchDescription.appendText("was ").appendText(item);
    }

    public void describeTo(Description description) {
        description.appendText("startsWithUpperCase");
    }

    @Factory
    public static Matcher<String> startWithUpperCase() {
        return new StartWithUpperCaseLetter();
    }
}
