package ru.yandex.autotests.direct.analyzer.perl;

import ru.yandex.autotests.direct.analyzer.lexer.Lexem;
import ru.yandex.autotests.direct.analyzer.perl.analyzer.FiniteStateMachine;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by alexey-n on 22.01.15.
 */
public class PerlAnalyzer {

    public static Map<String, PerlModule> analyze(Map<String, List<Lexem>> lexemMap) {
        Map<String, PerlModule> modules = new HashMap<String, PerlModule>();
        for (String key:lexemMap.keySet()) {
            List<Lexem> lexems = lexemMap.get(key);
            PerlModule perlModule = new PerlModule();
            FiniteStateMachine machine = new FiniteStateMachine(perlModule);
            for (Lexem lexem : lexems) {
                machine.makeIteration(lexem);
            }

            perlModule.setPerlPackage(key);
            modules.put(key, perlModule);
        }
        for (PerlModule module : modules.values()) {
            module.initCalledFunction();
        }

        return modules;
    }

}
