package ru.yandex.autotests.direct.analyzer.perl;

import ru.yandex.autotests.direct.analyzer.perl.PerlUse;
import ru.yandex.autotests.direct.analyzer.lexer.Lexem;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by alexey-n on 18.11.14.
 */
public class PerlFunction {

    private PerlModule perlModule;
    private boolean changed;
    private int calledMe;
    private String functionName;
    private List<Lexem> functionDeclaration;
    private List<PerlFunction> calledFunction;

    public PerlFunction() {
        functionDeclaration = new ArrayList<Lexem>();
        calledFunction = new ArrayList<PerlFunction>();
        calledMe = 0;
    }

    public String getFunctionName() {
        return functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public List<Lexem> getFunctionDeclaration() {
        return functionDeclaration;
    }

    public void setFunctionDeclaration(List<Lexem> functionDeclaration) {
        this.functionDeclaration = functionDeclaration;
    }

    public PerlModule getPerlModule() {
        return perlModule;
    }

    public void setPerlModule(PerlModule perlModule) {
        this.perlModule = perlModule;
    }

    public void initCalledFunction() {
        for(Lexem lexem:functionDeclaration) {
            if(lexem.getName().equals("Call") || lexem.getName().equals("Key") || lexem.getName().equals("Namespace")) {
                if (lexem.getData().equals("new")
                        || lexem.getData().equals("usage")
                        || lexem.getData().equals("options")
                        || lexem.getData().equals("type")
                        || lexem.getData().equals("strategy")
                        || lexem.getData().equals("error")
                        || lexem.getData().equals("data")
                        || lexem.getData().equals("Cmd")
                        || lexem.getData().equals("Description")) {
                    continue;
                }
                List<PerlFunction> functions = PerlScope.getFunction(lexem.getData());
                if (functions != null && functions.size() > 0) {
                    boolean collision = false, finded = false;
                    if (functions.size() == 1) {
                        if(!calledFunction.contains(functions.get(0))) {
                            calledFunction.add(functions.get(0));
                        }
                    } else {
                        for (PerlFunction function : functions) {
                            if (function.getPerlModule().getPerlPackage().equals(perlModule.getPerlPackage())) {
                                finded = true;
                                if (!calledFunction.contains(function)) {
                                    calledFunction.add(function);
                                }
                                break;
                            }
                        }
                        if (!finded) {
                            for (PerlFunction function : functions) {
                                for (PerlUse perlUse : perlModule.getUse()) {
                                    if (function.getPerlModule().getPerlPackage().toLowerCase()
                                            .contains(perlUse.getUseString().toLowerCase())
                                            && perlUse.getUseString().length() >= 2) {
                                        if (finded == true && !calledFunction.contains(function)) {
                                            collision = true;
                                        }
                                        if (!calledFunction.contains(function) && !finded) {
                                            calledFunction.add(function);
                                        }
                                        finded = true;
                                    }
                                }
                            }
                        }
                    }
                    if (collision) {
                        calledFunction.remove(calledFunction.get(calledFunction.size() - 1));
                    }
                }
            }
        }
    }

    public List<PerlFunction> getCalledFunction() {
        return calledFunction;
    }

    public void incCalledMe() {
        calledMe++;
    }

    public int getCalledMe() {
        return calledMe;
    }

    public boolean isChanged() {
        return changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}
