package ru.yandex.autotests.direct.analyzer.perl;

import ru.yandex.autotests.direct.analyzer.perl.PerlFunction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by alexey-n on 18.11.14.
 */
public class PerlScope {

    private static Map<String, List<PerlFunction>> functions = new HashMap<String, List<PerlFunction>>();

    public static void addFunction(PerlFunction function) {
        List<PerlFunction> list = functions.get(function.getFunctionName());
        if (list != null) {
            if (!list.contains(function)) {
                list.add(function);
            }
        } else {
            list = new ArrayList<PerlFunction>();
            list.add(function);
            functions.put(function.getFunctionName(), list);
        }
    }

    public static List<PerlFunction> getFunction(String name) {
        return functions.get(name);
    }
}
