package ru.yandex.autotests.direct.analyzer.perl.analyzer;

import ru.yandex.autotests.direct.analyzer.lexer.Lexem;
import ru.yandex.autotests.direct.analyzer.perl.PerlFunction;
import ru.yandex.autotests.direct.analyzer.perl.PerlModule;
import ru.yandex.autotests.direct.analyzer.perl.PerlScope;
import ru.yandex.autotests.direct.analyzer.perl.PerlUse;

/**
 * Created by alexey-n on 22.01.15.
 */
public class FiniteStateMachine {

    private int state = 1;
    private int braces = 0;
    private int parenthesis = 0;
    private PerlFunction perlFunction = null;
    private PerlUse perlUse = null;
    private PerlModule perlModule;

    public FiniteStateMachine(PerlModule perlModule) {
        this.perlModule = perlModule;
    }

    public void makeIteration(Lexem lexem) {
        switch (state) {
            case 1:
                checkFunctionDecl(lexem);
                checkUseDecl(lexem);
                if (!lexem.getName().equals("FunctionDecl") && !lexem.getName().equals("UseDecl")) {
                    perlModule.addOutOfFunctionLexem(lexem);
                }
                break;
            case 2:
                perlFunction.getFunctionDeclaration().add(lexem);
                if (lexem.getName().equals("Function")) {
                    perlFunction.setFunctionName(lexem.getData()
                            .replaceAll("\\r", "").replaceAll("\\t", "").replaceAll("\\n", ""));
                }
                checkBracesInFunctionHead(lexem);
                break;
            case 3:
                perlFunction.getFunctionDeclaration().add(lexem);
                checkBracesInFunctionBody(lexem);
                break;
            case 4:
                perlUse.getUseDeclaration().add(lexem);
                if (lexem.getName().equals("SemiColon")) {
                    state = 1;
                    perlModule.addUse(perlUse);
                }
                break;
        }
    }

    private void checkFunctionDecl(Lexem lexem) {
        if (lexem.getName().equals("FunctionDecl")) {
            perlFunction = new PerlFunction();
            perlFunction.getFunctionDeclaration().add(lexem);
            state = 2;
        }
    }

    private void checkUseDecl(Lexem lexem) {
        if (lexem.getName().equals("UseDecl")) {
            state = 4;
            perlUse = new PerlUse();
            perlUse.getUseDeclaration().add(lexem);
        }
    }

    private void checkBracesInFunctionHead(Lexem lexem) {
        if (lexem.getName().equals("LeftParenthesis")) {
            parenthesis++;
        }
        if (lexem.getName().equals("RightParenthesis")) {
            parenthesis--;
        }
        if (lexem.getName().equals("LeftBrace") && parenthesis == 0) {
            braces = 1;
            state = 3;
        }
    }

    private void checkBracesInFunctionBody(Lexem lexem) {
        if (lexem.getName().equals("LeftBrace")
                || lexem.getName().equals("ArraySizeDereference")
                || lexem.getName().equals("HashDereference")
                || lexem.getName().equals("CodeDereference")
                || lexem.getName().equals("ArrayDereference")
                || lexem.getName().equals("ScalarDereference")) {
            braces++;
        }
        if (lexem.getName().equals("RightBrace")) {
            braces--;
        }
        if (braces <= 0) {
            state = 1;
            if (perlFunction.getFunctionName() != null) {
                PerlScope.addFunction(perlFunction);
                perlModule.putFunction(perlFunction.getFunctionName(),
                        perlFunction);
            }
        }
    }

}
