package ru.yandex.autotests.direct.analyzer.svndiff;

import ru.yandex.autotests.direct.analyzer.perl.PerlFunction;
import ru.yandex.autotests.direct.analyzer.perl.PerlModule;

import java.util.List;
import java.util.Map;

/**
 * Created by alexey-n on 22.01.15.
 */
public class ChangesHelper {

    public static void detectChangedFunctions(List<FileDiff> fileDiffs, Map<String ,PerlModule> modules) {
        for (FileDiff fileDiff : fileDiffs) {
            PerlModule module = modules.get(fileDiff.getName());
            if (module != null) {
                for (PerlFunction function : module.getDeclaredFunctions().values()) {
                    int start, end;
                    start = function.getFunctionDeclaration().get(0).getLine();
                    end = function.getFunctionDeclaration().get(function.getFunctionDeclaration().size() - 1).getLine();

                    if (fileDiff.changed(start, end)) {
                        function.setChanged(true);
                    }
                }
            }
        }
    }
}
