package ru.yandex.autotests.direct.analyzer.svndiff;

import ru.yandex.autotests.direct.analyzer.Main;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by alexey-n on 12.12.14.
 */
public class FileDiff {

    List<String> lines;
    List<ChangesBlock> splittedLines;

    private void splitLines() {
        splittedLines = new ArrayList<ChangesBlock>();
        int size = lines.size();
        ChangesBlock changesBlock = null;
        for(int index = 4; index < size; ++index) {
            if (lines.get(index).startsWith("@@")) {
                if (changesBlock != null) {
                    splittedLines.add(changesBlock);
                }
                changesBlock = new ChangesBlock();
                if (Main.DEBUG) {
                    System.out.println(lines.get(index));
                }
                String[] tokens = lines.get(index).replaceAll("@@", "").replaceAll("\\+", "").replaceAll("\\-", "")
                        .replaceAll(",", " ").split(" ");
                if(tokens.length < 4) {
                    changesBlock = null;
                    continue;
                }
                changesBlock.setRemoveLineNumber(Integer.parseInt(tokens[1]));
                changesBlock.setRemoveLinesCount(Integer.parseInt(tokens[2]));
                changesBlock.setAddLineNumber(Integer.parseInt(tokens[3]));
                if (tokens.length < 5) {
                    changesBlock.setAddLinesCount(1);
                } else {
                    changesBlock.setAddLinesCount(Integer.parseInt(tokens[4]));
                }
            } else {
                if(changesBlock == null) {
                    continue;
                }
                String line = lines.get(index);

                if(line.startsWith(" ") || line.startsWith("+") || line.startsWith("-")) {
                    if (line.startsWith(" ")) {
                        changesBlock.addLine(LineType.UNCHANGED);
                    }
                    if (line.startsWith("+")) {
                        if (line.startsWith("+#") || line.replaceAll(" ","").equals("+")) {
                            changesBlock.addLine(LineType.ADD_MINOR);
                        } else {
                            changesBlock.addLine(LineType.ADD);
                        }
                    }
                    if (line.startsWith("-")) {
                        if (line.startsWith("-#") || line.replaceAll(" ","").equals("-")) {
                            changesBlock.addLine(LineType.REMOVE_MINOR);
                        } else {
                            changesBlock.addLine(LineType.REMOVE);
                        }
                    }
                }
            }
        }
    }

    public FileDiff(List<String> lines) {
        this.lines = lines;
        if (!getName().equals(".")) {
            splitLines();
        }
    }

    public List<String> getLines() {
        return lines;
    }

    public String getName() {
        if (lines.size() > 0) {
            String name = lines.get(0).replaceAll("Index: ", "").replaceAll("/", "::");
            if (name.endsWith(".pl") || name.endsWith(".pm")) {
                name = name.replaceAll("\\.pl", "").replaceAll("\\.pm", "");
            }
            return name;
        } else {
            return "null";
        }
    }

    public boolean changed(int start, int end) {
        for(ChangesBlock block:splittedLines) {
            int blockStart, blockEnd;
            blockStart = block.getAddLineNumber() - 1;
            blockEnd = block.getAddLinesCount() + blockStart;
            if (!(blockStart > end && blockEnd < start)) {
                for(LineType lineType:block.getLines()) {
                    switch (lineType) {
                        case REMOVE:
                            if (start <= blockStart && end >= blockStart) {
                                return true;
                            }
                            break;
                        case ADD_MINOR:
                        case UNCHANGED:
                            blockStart++;
                            break;
                        case ADD:
                            blockStart++;
                            if (start <= blockStart && end >= blockStart) {
                                return true;
                            }
                            break;
                    }
                }
            }
        }
        return false;
    }
}
