package ru.yandex.autotests.direct.analyzer.svndiff;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by alexey-n on 12.12.14.
 */
public class FileParser {

    public static List<FileDiff> parseSvnDiff(File svnDiff) {
        List<FileDiff> fileDiffs = new ArrayList<FileDiff>();
        List<String> lines = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(svnDiff));
            String line = bufferedReader.readLine();
            while(line != null) {
                lines.add(line);
                line = bufferedReader.readLine();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        List<String> fileDiffLines = new ArrayList<String>();

        for(String line:lines) {
            if (line.startsWith("Index: ")) {
                if (fileDiffLines.size() > 0) {
                    fileDiffs.add(new FileDiff(fileDiffLines));
                }
                fileDiffLines = new ArrayList<String>();
            }
            fileDiffLines.add(line);
        }
        if (fileDiffLines.size() > 0) {
            FileDiff diff = new FileDiff(fileDiffLines);
            if (!diff.getName().equals(".")) {
                fileDiffs.add(diff);
            }
        }

        return fileDiffs;
    }
}
