package ru.yandex.autotests.direct.analyzer.tree;

import org.codehaus.jackson.annotate.JsonProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by alexey-n on 18.11.14.
 */
public class FunctionTree implements Comparable<FunctionTree> {

    private String name;
    private List<FunctionTree> children;
    private boolean changed;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("_children")
    public List<FunctionTree> getChildren() {
        return children;
    }

    @JsonProperty("_children")
    public void setChildren(List<FunctionTree> children) {
        this.children = children;
    }

    public void addChildren(FunctionTree child) {
        if (children == null) {
            children = new ArrayList<FunctionTree>();
        }
        children.add(child);
    }

    @Override
    public int compareTo(FunctionTree o) {
        if (changed != o.changed) {
            if (changed) {
                return -1;
            } else {
                return 1;
            }
        }
        return this.name.compareTo(o.name);
    }

    public boolean isChanged() {
        return changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}
