package ru.yandex.autotests.direct.analyzer.tree;

import ru.yandex.autotests.direct.analyzer.perl.PerlModule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by alexey-n on 22.01.15.
 */
public class FunctionTreeBuilder {

    private FunctionTree functionTree;
    private List<NodeBuilder> nodeBuilders;
    private Map<String, PerlModule> modules;

    public FunctionTreeBuilder(Map<String, PerlModule> modules) {
        functionTree = new FunctionTree();
        functionTree.setName("Ya.Direct");
        nodeBuilders = new ArrayList<NodeBuilder>();
        this.modules = modules;
    }

    public NodeBuilder withNode(String nodeName) {
        NodeBuilder builder = new NodeBuilder(nodeName, modules);
        nodeBuilders.add(builder);
        return builder;
    }

    public FunctionTree build() {
        for(NodeBuilder builder:nodeBuilders) {
            System.out.println("BUILD NODE: " + builder.getName());
            functionTree.addChildren(builder.build());
        }

        return functionTree;
    }
}
