package ru.yandex.autotests.direct.analyzer.tree;

import ru.yandex.autotests.direct.analyzer.perl.PerlFunction;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by alexey-n on 22.01.15.
 */
public class TreeHelper {

    public static void recoursiveTreeSort(FunctionTree tree) {
        if (tree != null && tree.getChildren() != null) {
            Collections.sort(tree.getChildren());
            for(FunctionTree child:tree.getChildren()) {
                recoursiveTreeSort(child);
            }
        }
    }

    public static boolean recoursiveChildAdd(PerlFunction function, FunctionTree tree, int depth,
                                             Map<String, String> callMap) {
        //String funcName = function.getPerlModule().getPerlPackage() + "->" + function.getFunctionName();
        /*if (funcName.equals("protected::Primitives->product_info_by_cid")
                || funcName.equals("perl::rbac-elementary::RBACElementary->rbac_is_internal_user")
                || funcName.equals("api::services::v5::API::Service::VCards->errors")) {
            return function.isChanged();
        }*/
        boolean result = function.isChanged();
        for (PerlFunction calledFunction : function.getCalledFunction()) {
            FunctionTree child = new FunctionTree();
            child.setName(calledFunction.getPerlModule().getPerlPackage() + "->" + calledFunction.getFunctionName());
            if (tree.getName().equals(child.getName())) {
                continue;
            }
            if (callMap.containsKey(calledFunction.getPerlModule().getPerlPackage() + "->" + calledFunction.getFunctionName())) {
                result |= calledFunction.isChanged();
            } else {
                callMap.put(calledFunction.getPerlModule().getPerlPackage() + "->" + calledFunction.getFunctionName(), "");
                boolean recResult = recoursiveChildAdd(calledFunction, child, depth + 1, callMap);
                callMap.remove(calledFunction.getPerlModule().getPerlPackage() + "->" + calledFunction.getFunctionName());
                result |= recResult;
                child.setChanged(recResult);
                tree.addChildren(child);
            }

        }
        return result;
    }

    public static void removeUnchanged(FunctionTree functionTree) {
        if(functionTree == null || functionTree.getChildren() == null) {
            return;
        }
        Iterator iterator = functionTree.getChildren().iterator();
        while (iterator.hasNext()) {
            FunctionTree tree = (FunctionTree) iterator.next();
            if (!tree.isChanged()) {
                iterator.remove();
            }
        }
    }
}
