#!/usr/bin/perl -w

use Compiler::Lexer;
use File::Basename qw( fileparse );
use File::Path qw( make_path );
use JSON;

my $filename = $ARGV[0];
print $ARGV[0]."\n";
print $ARGV[1]."\n";
my ( $resultFileName, $dir ) = fileparse $ARGV[1];
open(my $fh, "<", $filename) or die("Cannot open file");
make_path $dir;
open(my $fout, ">", $ARGV[1]) or die("Cannot create file");
my $script = do { local $/; <$fh> };
my $lexer = Compiler::Lexer->new($filename);
my $tokens = $lexer->tokenize($script);
my @tokenArray = ();

foreach $item(@$tokens) {
 push @tokenArray, to_json({ %$item });
}
print $fout "[".join(",\n", @tokenArray)."]";
close $fout;
close $fh;
