#!/bin/bash
JAVA_ARGS="-Djava.net.preferIPv6Addresses=true -Dfile.encoding=UTF-8 -Xms${APP_XMS:-6G} -Xmx${APP_XMX:-6G} -DLOG_LEVEL=${LOG_LEVEL:-ERROR} -XX:+HeapDumpOnOutOfMemoryError"

if [ $DEBUG_PORT ]
then
JAVA_ARGS="$JAVA_ARGS -agentlib:jdwp=transport=dt_socket,server=y,address=$DEBUG_PORT,suspend=${SUSPEND:-n} "
fi

exec /usr/local/java8/bin/java $JAVA_ARGS -XX:OnOutOfMemoryError="kill -9 %p; ./app-start.sh" -Dport=${QLOUD_HTTP_PORT} -jar /usr/share/apisteps-proxy-1.0-SNAPSHOT-jar-with-dependencies.jar

