package ru.yandex.direct.proxy.configuration;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;

import ru.yandex.direct.proxy.model.StepTimeWrapper;
import ru.yandex.direct.proxy.service.StepsStorage;
import ru.yandex.direct.proxy.service.TokenStorageService;

@Configuration
@ComponentScan(
        basePackages = {
                "ru.yandex.direct.proxy"
        },
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
public class DirectProxyCoreConfiguration {
    private static final int LIVE_TIME_OF_CACHE_ITEM_IN_MINUTES = 5;
    private static final int DEFAULT_CACHE_SIZE = 500;

    @Bean
    public TokenStorageService tokenStorageService() {
        Cache<String, StepTimeWrapper> cache = CacheBuilder.newBuilder()
                .expireAfterAccess(LIVE_TIME_OF_CACHE_ITEM_IN_MINUTES, TimeUnit.MINUTES)
                .maximumSize(DEFAULT_CACHE_SIZE)
                .build();

        return new TokenStorageService(new ConcurrentHashMap<>(DEFAULT_CACHE_SIZE), cache);
    }

    @Bean(name = "stepsStorage")
    public StepsStorage stepsStorage()
    {
        return StepsStorage.create();
    }
}
