package ru.yandex.direct.proxy.model;

import java.util.List;

public class ExecuteStepData {
    private String token;

    private StepPath stepPath;

    private List<StepArgument> args;

    public String getToken() {
        return token;
    }

    public ExecuteStepData withToken(String token) {
        this.token = token;
        return this;
    }

    public StepPath getStepPath() {
        return stepPath;
    }

    public ExecuteStepData withStepPath(StepPath stepPath) {
        this.stepPath = stepPath;
        return this;
    }

    public List<StepArgument> getArgs() {
        return args;
    }

    public ExecuteStepData withArgs(List<StepArgument> args) {
        this.args = args;
        return this;
    }

    @Override
    public String toString() {
        return "ExecuteStepData{" +
                "token='" + token + '\'' +
                ", stepPath=" + stepPath +
                ", args=" + args +
                '}';
    }
}
