package ru.yandex.direct.proxy.model;

import java.io.IOException;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.mchange.v1.lang.ClassUtils;

import ru.yandex.direct.proxy.model.web.callstep.Parameter;
import ru.yandex.direct.proxy.service.ObjectGenerator;


@JsonDeserialize(using = ParameterData.ParameterJsonDeserializer.class)
public class ParameterData<T> {
    private static ObjectMapper objectMapper = new ObjectMapper();

    @JsonProperty("value")
    private T value;

    @JsonProperty("name")
    private String name;

    @JsonProperty("clazz")
    private Class<T> clazz;


    public Class<T> getClazz() {
        return clazz;
    }

    public ParameterData withClazz(Class<T> clazz) {
        this.clazz = clazz;
        return this;
    }

    public T getValue() {
        return value;
    }

    public ParameterData withValue(T value) {
        this.value = value;
        return this;
    }

    public String getName() {
        return name;
    }

    public ParameterData withParameterName(String parameterName) {
        this.name = parameterName;
        return this;
    }

    public ParameterData generateValue() {
        this.withValue((T) ObjectGenerator.generate(this.clazz));
        return this;
    }

    @Override
    public String toString() {
        return "ParameterData{" +
                "clazz=" + clazz +
                ", value=" + value +
                '}';
    }

    public static class ParameterJsonDeserializer extends JsonDeserializer<ParameterData> {
        static <T> T parseClass(String argument, Class<T> classOfT) {
            try {
                return objectMapper.readValue(argument, classOfT);
            } catch (IOException e) {
                throw new IllegalArgumentException("invalid args", e);
            }
        }

        @Override
        public ParameterData deserialize(JsonParser jp, DeserializationContext ctxt)
                throws IOException
        {
            ParameterData result = new ParameterData();
            Parameter parameterWeb = jp.readValueAs(Parameter.class);
            result.withParameterName(parameterWeb.getName());
            try {
                result.withClazz(ClassUtils.forName(parameterWeb.getClazz()));
            } catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("invalid class name", e);
            }
            result.withValue(parseClass(parameterWeb.getValue(), result.getClazz()));
            return result;
        }
    }
}
