package ru.yandex.direct.proxy.model;

public class StepPath {
    private StepTypeEnum stepsTypeEnum;
    private String subStepGetterName;
    private String stepMethodName;

    public StepPath(StepTypeEnum stepsTypeEnum, String subStepGetterName, String stepMethodName) {
        this.stepsTypeEnum = stepsTypeEnum;
        this.subStepGetterName = subStepGetterName;
        this.stepMethodName = stepMethodName;
    }

    public StepTypeEnum getStepsTypeEnum() {
        return stepsTypeEnum;
    }

    public StepPath withStepTypeEnum(StepTypeEnum stepsTypeEnum) {
        this.stepsTypeEnum = stepsTypeEnum;
        return this;
    }

    public String getSubStepGetterName() {
        return subStepGetterName;
    }

    public StepPath withSubStepGetterName(String subStepGetterName) {
        this.subStepGetterName = subStepGetterName;
        return this;
    }

    public String getStepMethodName() {
        return stepMethodName;
    }

    public StepPath withStepMethodName(String stepMethodName) {
        this.stepMethodName = stepMethodName;
        return this;
    }

    @Override
    public String toString() {
        return stepsTypeEnum.toString() + "." + subStepGetterName + "." + stepMethodName;
    }

}
