package ru.yandex.direct.proxy.model;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.proxy.model.web.InitStepRequest;


@JsonSerialize(using = StepTimeWrapper.Serializer.class)
public class StepTimeWrapper {
    private final LocalDateTime createDate;
    private final StepTypeEnum stepsTypeEnum;
    private final ImmutableMap<Class, Object> steps;
    private final InitStepRequest meta;
    private LocalDateTime lastAccessDate;

    public StepTimeWrapper(Map<Class, Object> steps, InitStepRequest meta) {
        this.meta = meta;
        this.createDate = LocalDateTime.now();
        this.lastAccessDate = this.createDate;
        this.steps = ImmutableMap.copyOf(steps);
        this.stepsTypeEnum = meta.getStepsTypeEnum();
    }

    public StepTimeWrapper updateLastChange(LocalDateTime lastChangeDate) {
        this.lastAccessDate = lastChangeDate;
        return this;
    }

    public LocalDateTime getCreateDate() {
        return createDate;
    }

    public <T> T getSteps(Class<T> stepClass) {
        return (T) steps.get(stepClass);
    }

    public InitStepRequest getMeta() {
        return meta;
    }

    public StepTypeEnum getStepsTypeEnum() {
        return stepsTypeEnum;
    }

    public LocalDateTime getLastAccessDate() {
        return lastAccessDate;
    }

    public static class Serializer extends JsonSerializer<StepTimeWrapper> {
        @Override
        public void serialize(StepTimeWrapper o, JsonGenerator jsonGenerator,
                SerializerProvider serializerProvider) throws IOException
        {
            Map<String, Object> objMap = new HashMap<>();
            objMap.put("created", o.getCreateDate().toString());
            objMap.put("last_accessed", o.getLastAccessDate().toString());
            objMap.put("meta", o.getMeta());
            serializerProvider.defaultSerializeValue(objMap, jsonGenerator);
        }
    }
}
