package ru.yandex.direct.proxy.model;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

import static ru.yandex.direct.proxy.service.Utils.createStepClassToTypeMap;

public enum StepTypeEnum {
    API,
    CMD,
    JAVA_WEB,
    DB,
    DARK_SIDE;
    private static final BiMap<Class<?>, StepTypeEnum> stepClassToType = createStepClassToTypeMap();
    private static final BiMap<String, StepTypeEnum> stepNameToType = createStepNameToTypeMap();

    public static StepTypeEnum fromStepClass(Class stepClass) {
        return stepClassToType.get(stepClass);
    }

    public static StepTypeEnum fromString(String stepClass) {
        return stepNameToType.get(stepClass);
    }


    private static BiMap<String, StepTypeEnum> createStepNameToTypeMap() {
        return ImmutableBiMap.<String, StepTypeEnum>builder()
                .put("ApiSteps", API)
                .put("DarkSideSteps", DARK_SIDE)
                .put("DirectJooqDbSteps", DB)
                .put("DirectCmdSteps", CMD)
                .put("DirectWebApiSteps", JAVA_WEB)
                .build();
    }

    @Override
    public String toString() {
        return stepNameToType.inverse().get(this);
    }
}
