package ru.yandex.direct.proxy.model.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.cache.CacheStats;

public class CacheStatItem {
    @JsonProperty("hit_count")
    private long hitCount;

    @JsonProperty("miss_count")
    private long missCount;

    @JsonProperty("load_success_count")
    private long loadSuccessCount;

    @JsonProperty("load_exception_count")
    private long loadExceptionCount;

    @JsonProperty("total_load_time")
    private long totalLoadTime;

    @JsonProperty("eviction_count")
    private long evictionCount;

    public static CacheStatItem fromCacheStat(CacheStats cacheStats) {
        return new CacheStatItem()
                .withEvictionCount(cacheStats.evictionCount())
                .withHitCount(cacheStats.hitCount())
                .withLoadExceptionCount(cacheStats.loadExceptionCount())
                .withLoadSuccessCount(cacheStats.loadSuccessCount())
                .withMissCount(cacheStats.missCount())
                .withTotalLoadTime(cacheStats.totalLoadTime());
    }

    public long getHitCount() {
        return hitCount;
    }

    public CacheStatItem withHitCount(long hitCount) {
        this.hitCount = hitCount;
        return this;
    }

    public long getMissCount() {
        return missCount;
    }

    public CacheStatItem withMissCount(long missCount) {
        this.missCount = missCount;
        return this;
    }

    public long getLoadSuccessCount() {
        return loadSuccessCount;
    }

    public CacheStatItem withLoadSuccessCount(long loadSuccessCount) {
        this.loadSuccessCount = loadSuccessCount;
        return this;
    }

    public long getLoadExceptionCount() {
        return loadExceptionCount;
    }

    public CacheStatItem withLoadExceptionCount(long loadExceptionCount) {
        this.loadExceptionCount = loadExceptionCount;
        return this;
    }

    public long getTotalLoadTime() {
        return totalLoadTime;
    }

    public CacheStatItem withTotalLoadTime(long totalLoadTime) {
        this.totalLoadTime = totalLoadTime;
        return this;
    }

    public long getEvictionCount() {
        return evictionCount;
    }

    public CacheStatItem withEvictionCount(long evictionCount) {
        this.evictionCount = evictionCount;
        return this;
    }
}
