package ru.yandex.direct.proxy.model.web;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.proxy.model.StepTypeEnum;

public class InitStepRequest {
    @JsonProperty("step_type")
    private StepTypeEnum stepsTypeEnum;

    @JsonProperty("direct_stage")
    private String directStage;
    @JsonProperty("direct_api_sandbox_ui_stage")
    private String directApiSandBoxUiStage;
    @JsonProperty("balance_stage_type")
    private String balanceStageType;

    @JsonProperty("version")
    private String version;
    @JsonProperty("locale")
    private String locale;
    @JsonProperty("login")
    private String login;

    @JsonProperty("shardForDbStep")
    private Integer shardForDbStep;
    @JsonProperty("shardForLogin")
    private String shardForLogin;

    public StepTypeEnum getStepsTypeEnum() {
        return stepsTypeEnum;
    }

    public InitStepRequest withStepsTypeEnum(StepTypeEnum stepsTypeEnum) {
        this.stepsTypeEnum = stepsTypeEnum;
        return this;
    }

    public String getDirectStage() {
        return directStage;
    }

    public void setDirectStage(String directStage) {
        this.directStage = directStage;
    }

    public InitStepRequest withDirectStage(String directStage) {
        this.directStage = directStage;
        return this;
    }

    public String getDirectApiSandBoxUiStage() {
        return directApiSandBoxUiStage;
    }

    public void setDirectApiSandBoxUiStage(String directApiSandBoxUiStage) {
        this.directApiSandBoxUiStage = directApiSandBoxUiStage;
    }

    public InitStepRequest withDirectApiSandBoxUiStage(String directApiSandBoxUiStage) {
        this.directApiSandBoxUiStage = directApiSandBoxUiStage;
        return this;
    }

    public String getBalanceStageType() {
        return balanceStageType;
    }

    public void setBalanceStageType(String balanceStageType) {
        this.balanceStageType = balanceStageType;
    }

    public InitStepRequest withBalanceStageType(String balanceStageType) {
        this.balanceStageType = balanceStageType;
        return this;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public InitStepRequest withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public InitStepRequest withLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public InitStepRequest withLogin(String login) {
        this.login = login;
        return this;
    }

    public Integer getShardForDbStep() {
        return shardForDbStep;
    }

    public InitStepRequest withShardForDbStep(Integer shardForDbStep) {
        this.shardForDbStep = shardForDbStep;
        return this;
    }

    public String getShardForLogin() {
        return shardForLogin;
    }

    public InitStepRequest withShardForLogin(String shardForLogin) {
        this.shardForLogin = shardForLogin;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitStepRequest)) {
            return false;
        }
        InitStepRequest that = (InitStepRequest) o;
        return getStepsTypeEnum() == that.getStepsTypeEnum() &&
                Objects.equals(getDirectStage(), that.getDirectStage()) &&
                Objects.equals(getDirectApiSandBoxUiStage(), that.getDirectApiSandBoxUiStage()) &&
                Objects.equals(getBalanceStageType(), that.getBalanceStageType()) &&
                Objects.equals(getVersion(), that.getVersion()) &&
                Objects.equals(getLocale(), that.getLocale()) &&
                Objects.equals(getLogin(), that.getLogin()) &&
                Objects.equals(getShardForDbStep(), that.getShardForDbStep()) &&
                Objects.equals(getShardForLogin(), that.getShardForLogin());
    }

    @Override
    public int hashCode() {

        return Objects.hash(getStepsTypeEnum(), getDirectStage(), getDirectApiSandBoxUiStage(), getBalanceStageType(),
                getVersion(), getLocale(), getLogin(), getShardForDbStep(), getShardForLogin());
    }
}
