package ru.yandex.direct.proxy.model.web;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.proxy.model.web.callstep.Parameter;

public class StepItem {
    @JsonProperty("params")
    private List<Parameter> parameterList;

    @JsonProperty("step")
    private String stepPath;

    @JsonProperty("return_type")
    private String returnType;


    public List<Parameter> getParameterList() {
        return parameterList;
    }

    public StepItem withParameterList(List<Parameter> parameterList) {
        this.parameterList = parameterList;
        return this;
    }

    public String getStepPath() {
        return stepPath;
    }

    public StepItem withStepPath(String stepPath) {
        this.stepPath = stepPath;
        return this;
    }

    public String getReturnType() {
        return returnType;
    }

    public StepItem withReturnType(String returnType) {
        this.returnType = returnType;
        return this;
    }
}
