package ru.yandex.direct.proxy.model.web.callstep;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import one.util.streamex.StreamEx;

public class CallStepRequest {
    @JsonProperty("token")
    private String token;

    @JsonProperty("params")
    private List<Parameter> parameterList;

    @JsonProperty("stepPath")
    private String stepPath;

    public String getToken() {
        return token;
    }

    public CallStepRequest withToken(String token) {
        this.token = token;
        return this;
    }

    public List<Parameter> getParameterList() {
        return parameterList;
    }

    public CallStepRequest withParameterList(List<Parameter> parameterList) {
        this.parameterList = parameterList;
        return this;
    }

    private String getStepPath() {
        return stepPath;
    }

    public List<String> getMethods() {
        return StreamEx.split(this.getStepPath(), "\\.").toList();
    }

    public CallStepRequest withStepPath(String stepPath) {
        this.stepPath = stepPath;
        return this;
    }


    @Override
    public String toString() {
        return "CallStepRequest{" +
                "token='" + token + '\'' +
                ", parameterList=" + parameterList +
                ", stepPath='" + stepPath + '\'' +
                '}';
    }
}
