package ru.yandex.direct.proxy.model.web.callstep;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.proxy.model.StepArgument;

public class ExecuteStepRequest {
    @JsonProperty("token")
    private String token;

    @JsonProperty("step")
    private String stepPath;

    @JsonProperty("params")
    private List<StepArgument> args;

    public String getToken() {
        return token;
    }

    public ExecuteStepRequest withToken(String token) {
        this.token = token;
        return this;
    }

    public String getStepPath() {
        return stepPath;
    }

    public ExecuteStepRequest withStepPath(String stepPath) {
        this.stepPath = stepPath;
        return this;
    }

    public List<StepArgument> getArgs() {
        return args;
    }

    public ExecuteStepRequest withArgs(List<StepArgument> args) {
        this.args = args;
        return this;
    }
}
